/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSInvocation;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSTimer;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewDrawableColorFormat;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.opengles.EAGLRenderingAPI;
import org.robovm.apple.uikit.UIApplication;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.apple.uikit.UIWindow;
import playn.core.AbstractPlatform;
import playn.core.Game;
import playn.core.Json;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.MouseStub;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.json.JsonImpl;
import playn.robovm.RoboAssets;
import playn.robovm.RoboAudio;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboKeyboard;
import playn.robovm.RoboLog;
import playn.robovm.RoboNet;
import playn.robovm.RoboPointer;
import playn.robovm.RoboRootViewController;
import playn.robovm.RoboStorage;
import playn.robovm.RoboTouch;

public class RoboPlatform
extends AbstractPlatform {
    private RoboAudio audio;
    private final RoboGraphics graphics;
    private final Json json;
    private final RoboKeyboard keyboard;
    private final RoboNet net;
    private final RoboPointer pointer;
    private final RoboStorage storage;
    private final RoboTouch touch;
    private final RoboAssets assets;
    private Game game;
    private OrientationListener orientListener;
    private final UIApplication app;
    private final UIWindow mainWindow;
    private final RoboRootViewController rootViewController;
    private final long gameStart = System.nanoTime();
    private final List<NSObject> lifecycleObservers = new ArrayList<NSObject>();
    private final ExecutorService pool = Executors.newFixedThreadPool(3);
    final int osVersion = this.getOSVersion();
    final Config config;

    public static RoboPlatform register(UIApplication app) {
        return RoboPlatform.register(app, new Config());
    }

    public static RoboPlatform register(UIApplication app, Config config) {
        return RoboPlatform.register(app, null, config);
    }

    public static RoboPlatform register(UIApplication app, UIWindow window, Config config) {
        RoboPlatform platform = new RoboPlatform(app, window, config);
        PlayN.setPlatform((Platform)platform);
        return platform;
    }

    public UIWindow window() {
        return this.mainWindow;
    }

    public UIViewController rootViewController() {
        return this.rootViewController;
    }

    public GLKView gameView() {
        return this.rootViewController.view;
    }

    public void setListener(OrientationListener listener) {
        this.orientListener = listener;
    }

    public void activate() {
        if (!this.config.embedded) {
            throw new IllegalStateException("Config.embedded must be true to enable manual lifecycle control");
        }
        this.registerLifecycleObservers();
        this.didBecomeActive();
    }

    public void terminate() {
        if (!this.config.embedded) {
            throw new IllegalStateException("Config.embedded must be true to enable manual lifecycle control");
        }
        this.willTerminate();
    }

    protected RoboPlatform(UIApplication app, UIWindow window, Config config) {
        super((Log)new RoboLog());
        this.app = app;
        this.config = config;
        EAGLContext ctx = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
        CGRect bounds = UIScreen.getMainScreen().getBounds();
        this.mainWindow = window == null ? new UIWindow(bounds) : window;
        this.rootViewController = new RoboRootViewController(this, ctx, this.mainWindow);
        this.mainWindow.setRootViewController((UIViewController)this.rootViewController);
        this.graphics = new RoboGraphics(this, this.mainWindow);
        this.json = new JsonImpl();
        this.keyboard = new RoboKeyboard(this);
        this.net = new RoboNet(this);
        this.pointer = new RoboPointer(this);
        this.touch = new RoboTouch(this);
        this.assets = new RoboAssets(this);
        this.storage = new RoboStorage(this);
        if (!config.embedded) {
            this.registerLifecycleObservers();
        }
    }

    public void invokeAsync(Runnable action) {
        this.pool.execute(action);
    }

    public Platform.Type type() {
        return Platform.Type.IOS;
    }

    public RoboAssets assets() {
        return this.assets;
    }

    public RoboAudio audio() {
        if (this.audio == null) {
            this.audio = new RoboAudio(this, this.config.openALSources);
        }
        return this.audio;
    }

    public RoboGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public RoboKeyboard keyboard() {
        return this.keyboard;
    }

    public RoboNet net() {
        return this.net;
    }

    public Mouse mouse() {
        return new MouseStub();
    }

    public RoboTouch touch() {
        return this.touch;
    }

    public RoboPointer pointer() {
        return this.pointer;
    }

    public float random() {
        return (float)Math.random();
    }

    public RoboStorage storage() {
        return this.storage;
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.gameStart) / 1000000L);
    }

    public void openURL(String url) {
        if (!this.app.openURL(new NSURL(url))) {
            this.log().warn("Failed to open URL: " + url);
        }
    }

    public void setPropagateEvents(boolean propagate) {
        this.touch.setPropagateEvents(propagate);
        this.pointer.setPropagateEvents(propagate);
    }

    public void run(Game game) {
        this.game = game;
        game.init();
        this.mainWindow.makeKeyAndVisible();
    }

    void willRotate(UIInterfaceOrientation toOrient, double duration) {
        if (this.orientListener != null) {
            this.orientListener.willRotate(toOrient, duration);
        }
    }

    void didRotate(UIInterfaceOrientation fromOrient) {
        if (this.orientListener != null) {
            this.orientListener.didRotate(fromOrient);
        }
    }

    void update() {
        this.runQueue.execute();
        this.game.tick(this.tick());
        this.graphics.ctx().flush();
    }

    void paint() {
        this.graphics.paint();
    }

    private void didBecomeActive() {
    }

    private void willEnterForeground() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.onResume();
            }
        });
    }

    private void willResignActive() {
    }

    private void didEnterBackground() {
        this.onPause();
    }

    private void willTerminate() {
        this.onExit();
        for (NSObject obs : this.lifecycleObservers) {
            NSNotificationCenter.getDefaultCenter().removeObserver(obs);
        }
        this.lifecycleObservers.clear();
        NSTimer.scheduledTimerWithTimeInterval$invocation$repeats$((double)this.config.timeForTermination, (NSInvocation)new NSInvocation(){

            public void invoke() {
                if (RoboPlatform.this.audio != null) {
                    RoboPlatform.this.audio.terminate();
                }
                PlayN.setPlatform(null);
            }
        }, (boolean)false);
    }

    private int getOSVersion() {
        String systemVersion = UIDevice.getCurrentDevice().getSystemVersion();
        int version = Integer.parseInt(systemVersion.split("\\.")[0]);
        return version;
    }

    private void registerLifecycleObservers() {
        UIApplication.Notifications.observeDidBecomeActive((Runnable)new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.didBecomeActive();
            }
        });
        UIApplication.Notifications.observeWillEnterForeground((Runnable)new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.willEnterForeground();
            }
        });
        UIApplication.Notifications.observeWillResignActive((Runnable)new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.willResignActive();
            }
        });
        UIApplication.Notifications.observeDidEnterBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.didEnterBackground();
            }
        });
        UIApplication.Notifications.observeWillTerminate((Runnable)new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.willTerminate();
            }
        });
    }

    public static interface OrientationListener {
        public void willRotate(UIInterfaceOrientation var1, double var2);

        public void didRotate(UIInterfaceOrientation var1);
    }

    public static class Config {
        public UIInterfaceOrientationMask orients = UIInterfaceOrientationMask.Portrait;
        public boolean iPadLikePhone = false;
        public int frameInterval = 1;
        public boolean interpolateCanvasDrawing = true;
        public int openALSources = 24;
        public float timeForTermination = 0.5f;
        public boolean embedded = false;
        public GLKViewDrawableColorFormat glBufferFormat = GLKViewDrawableColorFormat.RGBA8888;
        public String storageFileName = "playn.db";
    }
}

