/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UIView;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Callback;
import playn.robovm.RoboPlatform;

public class RoboRootViewController
extends GLKViewController
implements GLKViewControllerDelegate {
    public final GLKView view;
    private final RoboPlatform platform;

    public RoboRootViewController(RoboPlatform pf, EAGLContext ctx, UIWindow hostWindow) {
        this.platform = pf;
        this.view = new GLKView(hostWindow.getBounds(), ctx){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(NSSet<UITouch> touches, UIEvent event) {
                RoboRootViewController.this.platform.touch().onTouchesBegan(touches, event);
                RoboRootViewController.this.platform.pointer().onTouchesBegan(touches, event);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(NSSet<UITouch> touches, UIEvent event) {
                RoboRootViewController.this.platform.touch().onTouchesCancelled(touches, event);
                RoboRootViewController.this.platform.pointer().onTouchesCancelled(touches, event);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(NSSet<UITouch> touches, UIEvent event) {
                RoboRootViewController.this.platform.touch().onTouchesEnded(touches, event);
                RoboRootViewController.this.platform.pointer().onTouchesEnded(touches, event);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(NSSet<UITouch> touches, UIEvent event) {
                RoboRootViewController.this.platform.touch().onTouchesMoved(touches, event);
                RoboRootViewController.this.platform.pointer().onTouchesMoved(touches, event);
            }

            public void draw(CGRect rect) {
                RoboRootViewController.this.platform.paint();
            }
        };
        this.view.setMultipleTouchEnabled(true);
        this.view.setDrawableColorFormat(this.platform.config.glBufferFormat);
        this.setView((UIView)this.view);
        this.setDelegate(this);
        this.setPreferredFramesPerSecond(60L);
    }

    public void update(GLKViewController self) {
        this.platform.update();
    }

    public void willPause(GLKViewController self, boolean paused) {
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        CGRect bounds = this.getView().getBounds();
        this.platform.graphics().ctx.viewDidInit((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    public void willRotate(UIInterfaceOrientation toOrient, double duration) {
        super.willRotate(toOrient, duration);
        this.platform.willRotate(toOrient, duration);
    }

    public void didRotate(UIInterfaceOrientation fromOrient) {
        super.didRotate(fromOrient);
        CGRect bounds = this.getView().getBounds();
        this.platform.graphics().setSize((int)bounds.getWidth(), (int)bounds.getHeight());
        this.platform.didRotate(fromOrient);
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        return this.platform.config.orients;
    }

    public boolean shouldAutorotate() {
        return true;
    }

    public boolean shouldAutorotateToInterfaceOrientation(UIInterfaceOrientation orientation) {
        return true;
    }

    @Callback
    @BindSelector(value="shouldAutorotateToInterfaceOrientation:")
    private static boolean shouldAutorotateToInterfaceOrientation(RoboRootViewController self, Selector sel, UIInterfaceOrientation orientation) {
        return self.shouldAutorotateToInterfaceOrientation(orientation);
    }
}

