/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UITouch;
import playn.core.Events;
import playn.core.Touch;
import playn.core.TouchImpl;
import playn.robovm.RoboPlatform;
import pythagoras.f.IPoint;

public class RoboTouch
extends TouchImpl {
    private final RoboPlatform platform;

    public RoboTouch(RoboPlatform platform) {
        this.platform = platform;
    }

    void onTouchesBegan(NSSet<UITouch> touches, UIEvent event) {
        this.onTouchStart(this.toTouchEvents(touches, event));
    }

    void onTouchesMoved(NSSet<UITouch> touches, UIEvent event) {
        this.onTouchMove(this.toTouchEvents(touches, event));
    }

    void onTouchesEnded(NSSet<UITouch> touches, UIEvent event) {
        this.onTouchEnd(this.toTouchEvents(touches, event));
    }

    void onTouchesCancelled(NSSet<UITouch> touches, UIEvent event) {
        this.onTouchCancel(this.toTouchEvents(touches, event));
    }

    private Touch.Event.Impl[] toTouchEvents(NSSet<UITouch> touches, UIEvent event) {
        Touch.Event.Impl[] events = new Touch.Event.Impl[touches.size()];
        int idx = 0;
        for (UITouch touch : touches) {
            CGPoint loc = touch.getLocation(touch.getView());
            IPoint xloc = this.platform.graphics().transformTouch((float)loc.x(), (float)loc.y());
            int id = (int)touch.getHandle();
            events[idx++] = new Touch.Event.Impl((Events.Flags)new Events.Flags.Impl(), touch.getTimestamp() * 1000.0, xloc.x(), xloc.y(), id);
        }
        return events;
    }
}

