/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDataReadingOptions;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSRange;
import playn.robovm.OpenAL;

public class CAFLoader {
    private static final NSDataReadingOptions READ_OPTS = new NSDataReadingOptions(NSDataReadingOptions.MappedIfSafe.value() | NSDataReadingOptions.Uncached.value());

    public static void load(File path, int bufferId) {
        try {
            NSData data = NSData.read((File)path, (NSDataReadingOptions)READ_OPTS);
            ByteBuffer buf = data.asByteBuffer().order(ByteOrder.BIG_ENDIAN);
            if (!CAFLoader.getString(buf, 4).equals("caff")) {
                throw new RuntimeException("Input file not CAFF: " + path);
            }
            buf.position(buf.position() + 4);
            CAFDesc desc = null;
            int offset = 8;
            int dataOffset = 0;
            int dataLength = 0;
            do {
                String type = CAFLoader.getString(buf, 4);
                int size = (int)buf.getLong();
                offset += 12;
                if (type.equals("data")) {
                    dataOffset = offset;
                    dataLength = size;
                } else if (type.equals("desc")) {
                    desc = new CAFDesc(buf);
                    if ("ima4".equalsIgnoreCase(desc.formatID)) {
                        throw new RuntimeException("Cannot use compressed CAFF. Use AIFC for compressed audio on iOS.");
                    }
                }
                buf.position(offset += size);
            } while (dataOffset == 0);
            ByteBuffer adata = data.getSubdata(new NSRange((long)dataOffset, (long)dataLength)).asByteBuffer();
            OpenAL.alBufferData(bufferId, desc.getALFormat(), adata, dataLength, (int)desc.sampleRate);
            data.dispose();
        }
        catch (NSErrorException nse) {
            throw new RuntimeException(nse);
        }
        int error = OpenAL.alGetError();
        if (error != 0) {
            throw new RuntimeException("AL error " + error);
        }
    }

    protected static String getString(ByteBuffer buf, int length) {
        byte[] data = new byte[length];
        buf.get(data);
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static class CAFDesc {
        public double sampleRate;
        public String formatID;
        public int formatFlags;
        public int bytesPerPacket;
        public int framesPerPacket;
        public int channelsPerFrame;
        public int bitsPerChannel;

        public CAFDesc(byte[] data) {
            this(ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN));
        }

        public CAFDesc(ByteBuffer buf) {
            this.sampleRate = buf.getDouble();
            this.formatID = CAFLoader.getString(buf, 4);
            this.formatFlags = buf.getInt();
            this.bytesPerPacket = buf.getInt();
            this.framesPerPacket = buf.getInt();
            this.channelsPerFrame = buf.getInt();
        }

        public int getALFormat() {
            switch (this.channelsPerFrame) {
                case 1: {
                    return this.bitsPerChannel == 8 ? 4352 : 4353;
                }
                case 2: {
                    return this.bitsPerChannel == 8 ? 4354 : 4355;
                }
            }
            return 4355;
        }

        public String toString() {
            return String.format("CAFHeader: sampleRate=%f formatID=%s formatFlags=%x bytesPerPacket=%d framesPerPacket=%d channelsPerFrame=%d bitsPerChannel=%d", this.sampleRate, this.formatID, this.formatFlags, this.bytesPerPacket, this.framesPerPacket, this.channelsPerFrame, this.bitsPerChannel);
        }
    }
}

