/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.apple.coregraphics.CGInterpolationQuality;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIImage;
import playn.core.Image;
import playn.core.Pattern;
import playn.core.gl.AbstractImageGL;
import playn.core.gl.GLContext;
import playn.core.gl.ImageGL;
import playn.core.gl.Scale;
import playn.core.util.Callback;
import playn.robovm.RoboBitmapTransformer;
import playn.robovm.RoboImage;
import playn.robovm.RoboPattern;

public abstract class RoboAbstractImage
extends ImageGL<CGBitmapContext>
implements Image {
    public UIImage toUIImage() {
        return new UIImage(this.cgImage());
    }

    public abstract CGImage cgImage();

    public boolean isReady() {
        return true;
    }

    public void addCallback(Callback<? super Image> callback) {
        callback.onSuccess((Object)this);
    }

    public Pattern toPattern() {
        return new RoboPattern((AbstractImageGL<?>)this, UIColor.fromPatternImage((UIImage)new UIImage(this.cgImage())).getCGColor(), this.repeatX, this.repeatY);
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        if (width <= 0 || height <= 0) {
            return;
        }
        int bytesPerRow = 4 * width;
        CGBitmapContext context = CGBitmapContext.create((long)width, (long)height, (long)8L, (long)bytesPerRow, (CGColorSpace)CGColorSpace.createDeviceRGB(), (CGBitmapInfo)new CGBitmapInfo(CGImageAlphaInfo.PremultipliedFirst.value()));
        context.setInterpolationQuality(CGInterpolationQuality.None);
        this.draw(context, 0.0f, 0.0f, (float)width, (float)height, (float)startX, (float)startY, (float)width, (float)height);
    }

    public Image transform(Image.BitmapTransformer xform) {
        UIImage ximage = new UIImage(((RoboBitmapTransformer)xform).transform(this.cgImage()));
        return new RoboImage(this.ctx, ximage.getCGImage(), this.scale);
    }

    public void draw(CGBitmapContext bctx, float x, float y, float width, float height) {
        CGImage cgImage = this.cgImage();
        bctx.saveGState();
        bctx.translateCTM((double)x, (double)(y += height));
        bctx.scaleCTM(1.0, -1.0);
        bctx.drawImage(new CGRect(0.0, 0.0, (double)width, (double)height), cgImage);
        bctx.restoreGState();
    }

    public void draw(CGBitmapContext bctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        sx *= this.scale.factor;
        sy *= this.scale.factor;
        CGImage cgImage = this.cgImage();
        float iw = cgImage.getWidth();
        float ih = cgImage.getHeight();
        float scaleX = dw / (sw *= this.scale.factor);
        float scaleY = dh / (sh *= this.scale.factor);
        bctx.saveGState();
        bctx.translateCTM((double)dx, (double)(dy + dh));
        bctx.scaleCTM(1.0, -1.0);
        bctx.clipToRect(new CGRect(0.0, 0.0, (double)dw, (double)dh));
        bctx.translateCTM((double)(-sx * scaleX), (double)(-(ih - (sy + sh)) * scaleY));
        bctx.drawImage(new CGRect(0.0, 0.0, (double)(iw * scaleX), (double)(ih * scaleY)), cgImage);
        bctx.restoreGState();
    }

    protected Pattern toSubPattern(AbstractImageGL<?> image, boolean repeatX, boolean repeatY, float x, float y, float width, float height) {
        CGImage subImage = CGImage.createWithImageInRect((CGImage)this.cgImage(), (CGRect)new CGRect((double)x, (double)y, (double)width, (double)height));
        return new RoboPattern(image, UIColor.fromPatternImage((UIImage)new UIImage(subImage)).getCGColor(), repeatX, repeatY);
    }

    protected RoboAbstractImage(GLContext ctx, Scale scale) {
        super(ctx, scale);
    }
}

