/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGImage;
import playn.core.Canvas;
import playn.core.CanvasImage;
import playn.core.Image;
import playn.core.gl.GLContext;
import playn.robovm.RoboAbstractImage;
import playn.robovm.RoboCanvas;
import playn.robovm.RoboGLContext;
import playn.robovm.RoboImage;

public class RoboCanvasImage
extends RoboAbstractImage
implements CanvasImage {
    private final RoboCanvas canvas;

    public RoboCanvasImage(RoboGLContext ctx, float width, float height, boolean interpolate) {
        super((GLContext)ctx, ctx.scale);
        this.canvas = new RoboCanvas(ctx, width, height, interpolate);
    }

    public Canvas canvas() {
        return this.canvas;
    }

    public Image snapshot() {
        return new RoboImage(this.ctx, this.canvas.cgImage(), this.scale);
    }

    @Override
    public CGImage cgImage() {
        return this.canvas.cgImage();
    }

    public float width() {
        return this.canvas.width();
    }

    public float height() {
        return this.canvas.height();
    }

    public int ensureTexture() {
        if (this.canvas.dirty()) {
            this.canvas.clearDirty();
            this.refreshTexture();
        }
        return super.ensureTexture();
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        throw new UnsupportedOperationException();
    }

    protected void updateTexture(int tex) {
        ((RoboGLContext)this.ctx).updateTexture(tex, this.canvas.texWidth(), this.canvas.texHeight(), this.canvas.data());
    }
}

