/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.rt.bro.ptr.IntPtr;
import playn.core.AbstractPlatform;
import playn.core.gl.GL20;
import playn.core.gl.GL20Context;
import playn.robovm.OpenGLES;
import playn.robovm.RoboGL20;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboPlatform;

public class RoboGLContext
extends GL20Context {
    public static final boolean CHECK_ERRORS = false;
    private final RoboPlatform platform;
    private int defaultFramebuffer = -1;

    public RoboGLContext(RoboPlatform platform, RoboGL20 gl, float scaleFactor) {
        super((AbstractPlatform)platform, (GL20)gl, scaleFactor, false);
        this.platform = platform;
        this.init();
    }

    void viewDidAppear() {
        this.gl.glDisable(2884);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(1, 771);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.defaultFramebuffer = this.gl.glGetInteger(36006);
    }

    protected int defaultFramebuffer() {
        return this.defaultFramebuffer;
    }

    void updateTexture(int tex, CGImage image) {
        int width = (int)image.getWidth();
        int height = (int)image.getHeight();
        if (width <= 0 || height <= 0) {
            this.platform.log().warn("Ignoring texture update for empty image (" + width + "x" + height + ").");
            return;
        }
        CGBitmapContext bctx = RoboGraphics.createCGBitmap(width, height);
        CGRect rect = new CGRect(0.0, 0.0, (double)width, (double)height);
        bctx.clearRect(rect);
        bctx.drawImage(rect, image);
        this.updateTexture(tex, width, height, bctx.getData());
        bctx.dispose();
    }

    void updateTexture(int tex, int width, int height, IntPtr data) {
        this.gl.glBindTexture(3553, tex);
        this.gl.glPixelStorei(3317, 1);
        OpenGLES.glTexImage2Dp(3553, 0, 6408, width, height, 0, 6408, 5121, data);
    }
}

