/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.uikit.UIAlertView;
import org.robovm.apple.uikit.UIAlertViewDelegate;
import org.robovm.apple.uikit.UIAlertViewDelegateAdapter;
import org.robovm.apple.uikit.UIAlertViewStyle;
import org.robovm.apple.uikit.UIKeyboardType;
import org.robovm.apple.uikit.UIReturnKeyType;
import org.robovm.apple.uikit.UITextAutocapitalizationType;
import org.robovm.apple.uikit.UITextAutocorrectionType;
import org.robovm.apple.uikit.UITextField;
import playn.core.Keyboard;
import playn.core.KeyboardImpl;
import playn.core.util.Callback;
import playn.robovm.RoboPlatform;

public class RoboKeyboard
extends KeyboardImpl {
    private final RoboPlatform platform;

    public RoboKeyboard(RoboPlatform platform) {
        this.platform = platform;
    }

    public boolean hasHardwareKeyboard() {
        return false;
    }

    public void getText(Keyboard.TextType textType, String label, String initVal, final Callback<String> callback) {
        UIAlertView view = new UIAlertView();
        if (label != null) {
            view.setTitle(label);
        }
        view.addButton("Cancel");
        view.addButton("OK");
        view.setAlertViewStyle(UIAlertViewStyle.PlainTextInput);
        final UITextField field = view.getTextField(0L);
        field.setReturnKeyType(UIReturnKeyType.Done);
        if (initVal != null) {
            field.setText(initVal);
        }
        switch (textType) {
            case NUMBER: {
                field.setKeyboardType(UIKeyboardType.NumberPad);
                break;
            }
            case EMAIL: {
                field.setKeyboardType(UIKeyboardType.EmailAddress);
                break;
            }
            case URL: {
                field.setKeyboardType(UIKeyboardType.URL);
                break;
            }
            case DEFAULT: {
                field.setKeyboardType(UIKeyboardType.Default);
            }
        }
        field.setAutocorrectionType(UITextAutocorrectionType.Yes);
        field.setAutocapitalizationType(UITextAutocapitalizationType.Sentences);
        field.setSecureTextEntry(false);
        view.setDelegate((UIAlertViewDelegate)new UIAlertViewDelegateAdapter(){

            public void clicked(UIAlertView view, long buttonIndex) {
                RoboKeyboard.this.platform.notifySuccess(callback, buttonIndex == 0L ? null : field.getText());
            }
        });
        view.show();
    }
}

