/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSTimer;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.glkit.GLKViewDrawableColorFormat;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.uikit.UIApplication;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.objc.block.VoidBlock1;
import playn.core.AbstractPlatform;
import playn.core.Game;
import playn.core.Json;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.MouseStub;
import playn.core.Platform;
import playn.core.json.JsonImpl;
import playn.robovm.RoboAssets;
import playn.robovm.RoboAudio;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboKeyboard;
import playn.robovm.RoboLog;
import playn.robovm.RoboNet;
import playn.robovm.RoboPointer;
import playn.robovm.RoboStorage;
import playn.robovm.RoboTouch;
import playn.robovm.RoboViewController;

public class RoboPlatform
extends AbstractPlatform {
    private RoboAudio audio;
    private final RoboGraphics graphics;
    private final Json json;
    private final RoboKeyboard keyboard;
    private final RoboNet net;
    private final RoboPointer pointer;
    private final RoboStorage storage;
    private final RoboTouch touch;
    private final RoboAssets assets;
    private boolean paused = false;
    private Game game;
    private OrientationListener orientListener;
    private final long gameStart = System.nanoTime();
    private final ExecutorService pool = Executors.newFixedThreadPool(3);
    public final int osVersion = this.getOSVersion();
    final Config config;

    public static RoboPlatform register(UIWindow window, Config config) {
        RoboViewController ctrl = new RoboViewController(window.getBounds(), config);
        window.setRootViewController((UIViewController)ctrl);
        return ctrl.platform();
    }

    public void setListener(OrientationListener listener) {
        this.orientListener = listener;
    }

    protected RoboPlatform(CGRect bounds, Config config) {
        super((Log)new RoboLog());
        this.config = config;
        bounds = bounds != null ? bounds : UIScreen.getMainScreen().getBounds();
        this.graphics = new RoboGraphics(this, bounds);
        this.json = new JsonImpl();
        this.keyboard = new RoboKeyboard(this);
        this.net = new RoboNet(this);
        this.pointer = new RoboPointer(this);
        this.touch = new RoboTouch(this);
        this.assets = new RoboAssets(this);
        this.storage = new RoboStorage(this);
    }

    public void invokeAsync(Runnable action) {
        this.pool.execute(action);
    }

    public Platform.Type type() {
        return Platform.Type.IOS;
    }

    public RoboAssets assets() {
        return this.assets;
    }

    public RoboAudio audio() {
        if (this.audio == null) {
            this.audio = new RoboAudio(this, this.config.openALSources);
        }
        return this.audio;
    }

    public RoboGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public RoboKeyboard keyboard() {
        return this.keyboard;
    }

    public RoboNet net() {
        return this.net;
    }

    public Mouse mouse() {
        return new MouseStub();
    }

    public RoboTouch touch() {
        return this.touch;
    }

    public RoboPointer pointer() {
        return this.pointer;
    }

    public float random() {
        return (float)Math.random();
    }

    public RoboStorage storage() {
        return this.storage;
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.gameStart) / 1000000L);
    }

    public void openURL(String url) {
        if (!UIApplication.getSharedApplication().openURL(new NSURL(url))) {
            this.log().warn("Failed to open URL: " + url);
        }
    }

    public void setPropagateEvents(boolean propagate) {
        this.touch.setPropagateEvents(propagate);
        this.pointer.setPropagateEvents(propagate);
    }

    public void run(Game game) {
        this.game = game;
        game.init();
    }

    void willRotate(UIInterfaceOrientation toOrient, double duration) {
        if (this.orientListener != null) {
            this.orientListener.willRotate(toOrient, duration);
        }
    }

    void didRotate(UIInterfaceOrientation fromOrient) {
        if (this.orientListener != null) {
            this.orientListener.didRotate(fromOrient);
        }
    }

    void update() {
        this.runQueue.execute();
        this.game.tick(this.tick());
        this.graphics.ctx().flush();
    }

    void paint() {
        this.graphics.paint();
    }

    void willEnterForeground() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.onResume();
            }
        });
    }

    void didEnterBackground() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.onPause();
    }

    void willTerminate() {
        this.onExit();
        new NSTimer((double)this.config.timeForTermination, (VoidBlock1)new VoidBlock1<NSTimer>(){

            public void invoke(NSTimer timer) {
                EAGLContext.setCurrentContext(null);
                if (RoboPlatform.this.audio != null) {
                    RoboPlatform.this.audio.terminate();
                }
            }
        }, null, false);
    }

    private int getOSVersion() {
        String systemVersion = UIDevice.getCurrentDevice().getSystemVersion();
        int version = Integer.parseInt(systemVersion.split("\\.")[0]);
        return version;
    }

    public static interface OrientationListener {
        public void willRotate(UIInterfaceOrientation var1, double var2);

        public void didRotate(UIInterfaceOrientation var1);
    }

    public static class Config {
        public UIInterfaceOrientationMask orients = UIInterfaceOrientationMask.Portrait;
        public boolean iPadLikePhone = false;
        public int frameInterval = 1;
        public boolean interpolateCanvasDrawing = true;
        public int openALSources = 24;
        public float timeForTermination = 0.5f;
        public GLKViewDrawableColorFormat glBufferFormat = GLKViewDrawableColorFormat.RGBA8888;
        public int targetFPS = 60;
        public String storageFileName = "playn.db";
        public int wsDraft = 10;
    }
}

