/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coretext.CTLine;
import org.robovm.apple.foundation.NSAttributedString;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIFont;
import playn.core.AbstractTextLayout;
import playn.core.TextFormat;
import playn.core.TextWrap;
import playn.robovm.CTFrame;
import playn.robovm.CTFramesetter;
import playn.robovm.RoboFont;
import playn.robovm.RoboGraphics;
import pythagoras.f.Rectangle;

class RoboTextLayout
extends AbstractTextLayout {
    private final RoboFont font;
    private CTLine fillLine;
    private int fillColor;
    private CTLine strokeLine;
    private float strokeWidth;
    private int strokeColor;

    public static RoboTextLayout layoutText(RoboGraphics gfx, String text, TextFormat format) {
        RoboFont font = format.font == null ? RoboGraphics.defaultFont : (RoboFont)format.font;
        NSAttributedStringAttributes attribs = RoboTextLayout.createAttribs(font);
        CTLine line = CTLine.create((NSAttributedString)new NSAttributedString(text, attribs));
        return new RoboTextLayout(gfx, text, format, font, line);
    }

    public static RoboTextLayout[] layoutText(RoboGraphics gfx, String text, TextFormat format, TextWrap wrap) {
        text = RoboTextLayout.normalizeEOL((String)text);
        RoboFont font = format.font == null ? RoboGraphics.defaultFont : (RoboFont)format.font;
        NSAttributedStringAttributes attribs = RoboTextLayout.createAttribs(font);
        CFArray lines = RoboTextLayout.wrapLines(new NSAttributedString(text, attribs), wrap.width);
        RoboTextLayout[] layouts = new RoboTextLayout[(int)lines.size()];
        for (int ii = 0; ii < layouts.length; ++ii) {
            CTLine line = (CTLine)lines.get((long)ii, CTLine.class);
            CFRange range = line.getStringRange();
            String ltext = text.substring((int)range.getLocation(), (int)(range.getLocation() + range.getLength()));
            layouts[ii] = new RoboTextLayout(gfx, ltext, format, font, line);
        }
        return layouts;
    }

    private static NSAttributedStringAttributes createAttribs(RoboFont font) {
        NSAttributedStringAttributes attribs = new NSAttributedStringAttributes();
        attribs.setFont((UIFont)font.ctFont.as(UIFont.class));
        return attribs;
    }

    private static void addStroke(NSAttributedStringAttributes attribs, RoboFont font, float strokeWidth, int strokeColor) {
        float strokePct = 100.0f * strokeWidth / font.size();
        attribs.setStrokeWidth((double)strokePct);
        attribs.setStrokeColor(RoboTextLayout.toUIColor(strokeColor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CFArray wrapLines(NSAttributedString astring, float wrapWidth) {
        CTFramesetter fs = CTFramesetter.create(astring);
        try {
            CGPath path = CGPath.createWithRect((CGRect)new CGRect(0.0, 0.0, (double)wrapWidth, 1.7014117331926443E38), (CGAffineTransform)CGAffineTransform.Identity());
            CTFrame frame = fs.createFrame(new CFRange(0L, 0L), path, null);
            CFArray cFArray = frame.getLines();
            return cFArray;
        }
        finally {
            fs.dispose();
        }
    }

    private RoboTextLayout(RoboGraphics gfx, String text, TextFormat format, RoboFont font, CTLine fillLine) {
        super(text, format, RoboTextLayout.computeBounds(font, fillLine.getImageBounds((CGContext)gfx.scratchCtx)));
        this.font = font;
        this.fillLine = fillLine;
    }

    public float ascent() {
        return (float)this.font.ctFont.getAscent();
    }

    public float descent() {
        return (float)this.font.ctFont.getDescent();
    }

    public float leading() {
        return (float)this.font.ctFont.getLeading();
    }

    void stroke(CGBitmapContext bctx, float x, float y, float strokeWidth, int strokeColor) {
        if (this.strokeLine == null || strokeWidth != this.strokeWidth || strokeColor != this.strokeColor) {
            this.strokeWidth = strokeWidth;
            this.strokeColor = strokeColor;
            NSAttributedStringAttributes attribs = RoboTextLayout.createAttribs(this.font);
            RoboTextLayout.addStroke(attribs, this.font, strokeWidth, strokeColor);
            this.strokeLine = CTLine.create((NSAttributedString)new NSAttributedString(this.text, attribs));
        }
        this.paint(bctx, this.strokeLine, x, y);
    }

    void fill(CGBitmapContext bctx, float x, float y, int fillColor) {
        if (this.fillColor != fillColor) {
            this.fillColor = fillColor;
            NSAttributedStringAttributes attribs = RoboTextLayout.createAttribs(this.font);
            attribs.setForegroundColor(RoboTextLayout.toUIColor(fillColor));
            this.fillLine = CTLine.create((NSAttributedString)new NSAttributedString(this.text, attribs));
        }
        this.paint(bctx, this.fillLine, x, y);
    }

    private void paint(CGBitmapContext bctx, CTLine line, float x, float y) {
        bctx.saveGState();
        bctx.translateCTM((double)x, (double)(y + this.ascent()));
        bctx.scaleCTM(1.0, -1.0);
        bctx.setShouldAntialias(this.format.antialias);
        bctx.setTextPosition(0.0, 0.0);
        line.draw((CGContext)bctx);
        bctx.restoreGState();
    }

    private static UIColor toUIColor(int color) {
        float blue = (float)(color & 0xFF) / 255.0f;
        float green = (float)((color >>= 8) & 0xFF) / 255.0f;
        float red = (float)((color >>= 8) & 0xFF) / 255.0f;
        float alpha = (float)((color >>= 8) & 0xFF) / 255.0f;
        return new UIColor((double)red, (double)green, (double)blue, (double)alpha);
    }

    private static Rectangle computeBounds(RoboFont font, CGRect bounds) {
        float ascent = (float)font.ctFont.getAscent();
        return new Rectangle((float)bounds.getMinX(), ascent - (float)(bounds.getHeight() + bounds.getMinY()), (float)bounds.getWidth(), (float)bounds.getHeight());
    }
}

