/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.opengles.EAGLRenderingAPI;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Callback;
import playn.core.Platform;
import playn.core.PlayN;
import playn.robovm.RoboPlatform;

public class RoboViewController
extends GLKViewController
implements GLKViewControllerDelegate {
    private final GLKView view;
    private final RoboPlatform platform;

    public RoboViewController(CGRect bounds, RoboPlatform.Config config) {
        EAGLContext ctx = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
        this.platform = new RoboPlatform(bounds, config);
        this.view = new GLKView(bounds, ctx){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.platform.touch().onTouchesBegan(touches, event);
                RoboViewController.this.platform.pointer().onTouchesBegan(touches, event);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.platform.touch().onTouchesCancelled(touches, event);
                RoboViewController.this.platform.pointer().onTouchesCancelled(touches, event);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.platform.touch().onTouchesEnded(touches, event);
                RoboViewController.this.platform.pointer().onTouchesEnded(touches, event);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.platform.touch().onTouchesMoved(touches, event);
                RoboViewController.this.platform.pointer().onTouchesMoved(touches, event);
            }

            public void draw(CGRect rect) {
                RoboViewController.this.platform.paint();
            }
        };
        this.view.setMultipleTouchEnabled(true);
        this.view.setDrawableColorFormat(this.platform.config.glBufferFormat);
        this.setView((UIView)this.view);
        this.setDelegate(this);
        this.setPreferredFramesPerSecond(config.targetFPS);
        this.addStrongRef((Object)this.platform);
        PlayN.setPlatform((Platform)this.platform);
    }

    public RoboPlatform platform() {
        return this.platform;
    }

    public void update(GLKViewController self) {
        this.platform.update();
    }

    public void willPause(GLKViewController self, boolean paused) {
        if (paused) {
            this.platform.didEnterBackground();
        } else {
            this.platform.willEnterForeground();
        }
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        EAGLContext.setCurrentContext((EAGLContext)this.view.getContext());
        this.platform.graphics().ctx.viewDidAppear();
        this.platform.graphics().setSize(this.getView().getBounds());
    }

    public void viewDidDisappear(boolean animated) {
        super.viewDidDisappear(animated);
        EAGLContext.setCurrentContext(null);
    }

    public void willRotate(UIInterfaceOrientation toOrient, double duration) {
        super.willRotate(toOrient, duration);
        this.platform.willRotate(toOrient, duration);
    }

    public void didRotate(UIInterfaceOrientation fromOrient) {
        super.didRotate(fromOrient);
        this.platform.graphics().setSize(this.getView().getBounds());
        this.platform.didRotate(fromOrient);
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        return this.platform.config.orients;
    }

    public boolean shouldAutorotate() {
        return true;
    }

    public boolean shouldAutorotateToInterfaceOrientation(UIInterfaceOrientation orientation) {
        return true;
    }

    protected void doDispose() {
        this.platform.willTerminate();
        this.removeStrongRef((Object)this.platform);
        super.doDispose();
    }

    @Callback
    @BindSelector(value="shouldAutorotateToInterfaceOrientation:")
    private static boolean shouldAutorotateToInterfaceOrientation(RoboViewController self, Selector sel, UIInterfaceOrientation orientation) {
        return self.shouldAutorotateToInterfaceOrientation(orientation);
    }
}

