/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.List;
import org.robovm.apple.uikit.UIImage;
import playn.core.AsyncImage;
import playn.core.Image;
import playn.core.gl.GLContext;
import playn.core.gl.Scale;
import playn.core.util.Callback;
import playn.core.util.Callbacks;
import playn.robovm.RoboImage;

public class RoboAsyncImage
extends RoboImage
implements AsyncImage<UIImage> {
    private final float preWidth;
    private final float preHeight;
    private List<Callback<? super Image>> callbacks;
    private Throwable error;

    public RoboAsyncImage(GLContext ctx, float preWidth, float preHeight) {
        super(ctx, null, Scale.ONE);
        this.preWidth = preWidth;
        this.preHeight = preHeight;
    }

    @Override
    public boolean isReady() {
        return this.image != null;
    }

    @Override
    public float width() {
        return this.image == null ? this.preWidth : super.width();
    }

    @Override
    public float height() {
        return this.image == null ? this.preHeight : super.height();
    }

    @Override
    public void addCallback(Callback<? super Image> callback) {
        if (this.error != null) {
            callback.onFailure(this.error);
        } else if (this.image != null) {
            callback.onSuccess((Object)this);
        } else {
            this.callbacks = Callbacks.createAdd(this.callbacks, callback);
        }
    }

    public void setImage(UIImage uiImage, Scale scale) {
        this.image = uiImage.getCGImage();
        this.scale = scale;
        this.callbacks = Callbacks.dispatchSuccessClear(this.callbacks, (Object)((Object)this));
    }

    public void setError(Throwable error) {
        this.error = error;
        this.image = new UIImage().getCGImage();
        this.callbacks = Callbacks.dispatchFailureClear(this.callbacks, (Throwable)error);
    }
}

