/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import playn.core.CanvasImage;
import playn.core.Font;
import playn.core.Gradient;
import playn.core.GroupLayer;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.core.gl.GL20;
import playn.core.gl.GLContext;
import playn.core.gl.GraphicsGL;
import playn.core.gl.GroupLayerGL;
import playn.robovm.RoboCanvasImage;
import playn.robovm.RoboFont;
import playn.robovm.RoboGL20;
import playn.robovm.RoboGLContext;
import playn.robovm.RoboGradient;
import playn.robovm.RoboPlatform;
import playn.robovm.RoboTextLayout;
import pythagoras.f.IPoint;
import pythagoras.f.Point;

public class RoboGraphics
extends GraphicsGL {
    static final CGColorSpace colorSpace = CGColorSpace.createDeviceRGB();
    static final RoboFont defaultFont = new RoboFont(null, "Helvetica", Font.Style.PLAIN, 12.0f);
    private final RoboPlatform platform;
    private final GroupLayerGL rootLayer;
    private final float touchScale;
    private final Point touchTemp = new Point();
    private int screenWidth;
    private int screenHeight;
    private static final int S_SIZE = 10;
    final CGBitmapContext scratchCtx = RoboGraphics.createCGBitmap(10, 10);
    final RoboGLContext ctx;

    public RoboGraphics(RoboPlatform platform, CGRect bounds) {
        this.platform = platform;
        float deviceScale = (float)UIScreen.getMainScreen().getScale();
        boolean isPad = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad;
        boolean useHalfSize = isPad && platform.config.iPadLikePhone;
        float viewScale = (float)(useHalfSize ? 2 : 1) * deviceScale;
        int screenWidth = (int)bounds.getWidth();
        int screenHeight = (int)bounds.getHeight();
        if (useHalfSize) {
            screenWidth /= 2;
            screenHeight /= 2;
        }
        this.touchScale = deviceScale;
        this.ctx = new RoboGLContext(platform, new RoboGL20(), viewScale);
        this.setSize(screenWidth, screenHeight);
        this.rootLayer = new GroupLayerGL((GLContext)this.ctx);
    }

    public CanvasImage createImage(float width, float height) {
        return new RoboCanvasImage(this.ctx, width, height, this.platform.config.interpolateCanvasDrawing);
    }

    public Gradient createLinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
        return new RoboGradient.Linear(x0, y0, x1, y1, colors, positions);
    }

    public Gradient createRadialGradient(float x, float y, float r, int[] colors, float[] positions) {
        return new RoboGradient.Radial(x, y, r, colors, positions);
    }

    public Font createFont(String name, Font.Style style, float size) {
        return new RoboFont(this, name, style, size);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return RoboTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return RoboTextLayout.layoutText(this, text, format, wrap);
    }

    public int screenHeight() {
        return this.screenHeight;
    }

    public int screenWidth() {
        return this.screenWidth;
    }

    public int height() {
        return this.ctx.viewHeight;
    }

    public int width() {
        return this.ctx.viewWidth;
    }

    public GroupLayer rootLayer() {
        return this.rootLayer;
    }

    public GL20 gl20() {
        return this.ctx.gl;
    }

    public GLContext ctx() {
        return this.ctx;
    }

    static CGBitmapContext createCGBitmap(int width, int height) {
        return CGBitmapContext.create((long)width, (long)height, (long)8L, (long)(4 * width), (CGColorSpace)colorSpace, (CGBitmapInfo)new CGBitmapInfo(CGImageAlphaInfo.PremultipliedLast.value()));
    }

    void setSize(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.ctx.setSize(screenWidth, screenHeight);
    }

    IPoint transformTouch(float x, float y) {
        return this.ctx.rootTransform().inverseTransform((IPoint)this.touchTemp.set(x * this.touchScale, y * this.touchScale), this.touchTemp);
    }

    void paint() {
        this.ctx.paint(this.rootLayer);
    }
}

