/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UITouch;
import playn.core.Events;
import playn.core.Pointer;
import playn.core.PointerImpl;
import playn.robovm.RoboPlatform;
import pythagoras.f.IPoint;

public class RoboPointer
extends PointerImpl {
    private final RoboPlatform platform;
    private long _active;

    public RoboPointer(RoboPlatform platform) {
        this.platform = platform;
    }

    void onTouchesBegan(NSSet<UITouch> touches, UIEvent event) {
        Pointer.Event.Impl ev = this.toPointerEvent(touches, event);
        if (ev != null) {
            this.onPointerStart(ev, false);
        }
    }

    void onTouchesMoved(NSSet<UITouch> touches, UIEvent event) {
        Pointer.Event.Impl ev = this.toPointerEvent(touches, event);
        if (ev != null) {
            this.onPointerDrag(ev, false);
        }
    }

    void onTouchesEnded(NSSet<UITouch> touches, UIEvent event) {
        Pointer.Event.Impl ev = this.toPointerEvent(touches, event);
        if (ev != null) {
            this.onPointerEnd(ev, false);
            this._active = 0L;
        }
    }

    void onTouchesCancelled(NSSet<UITouch> touches, UIEvent event) {
        Pointer.Event.Impl ev = this.toPointerEvent(touches, event);
        if (ev != null) {
            this.onPointerCancel(ev, false);
            this._active = 0L;
        }
    }

    private Pointer.Event.Impl toPointerEvent(NSSet<UITouch> touches, UIEvent event) {
        for (UITouch touch : touches) {
            long handle = touch.getHandle();
            if (this._active != 0L && handle != this._active) continue;
            this._active = handle;
            CGPoint loc = touch.getLocationInView(touch.getView());
            IPoint xloc = this.platform.graphics().transformTouch((float)loc.getX(), (float)loc.getY());
            return new Pointer.Event.Impl((Events.Flags)new Events.Flags.Impl(), touch.getTimestamp() * 1000.0, xloc.x(), xloc.y(), true);
        }
        return null;
    }
}

