/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.qlink.mem.behavior;

import com.googlecode.qlink.api.behavior.DoResultAsList;
import com.googlecode.qlink.api.functor.Function2;
import com.googlecode.qlink.api.functor.SamplePredicate;
import com.googlecode.qlink.api.functor.Visitor2;
import com.googlecode.qlink.core.context.IPipelineContext;
import com.googlecode.qlink.core.context.enums.ESampleType;
import com.googlecode.qlink.core.functor.SamplePredicates;
import com.googlecode.qlink.core.utils.StackPruningUtils;
import com.googlecode.qlink.mem.behavior.MemDoResultSupport;
import com.googlecode.qlink.mem.context.MemPipelineContext;
import com.googlecode.qlink.mem.pruning.MemPruningRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class MemDoResultAsList<T, TPlugin>
extends MemDoResultSupport
implements DoResultAsList<T, TPlugin> {
    public MemDoResultAsList(IPipelineContext ctxt) {
        super(ctxt);
    }

    private MemPipelineContext getMemCtxt() {
        return (MemPipelineContext)this.getCtxt();
    }

    public List<T> toList() {
        Function2<?, Integer, ?> func;
        Visitor2 visitor;
        SamplePredicate samplePredicate;
        Comparator c;
        ArrayList lstRes = new ArrayList();
        lstRes.addAll(this.getMemCtxt().getSourceList());
        final com.googlecode.qlink.api.functor.Predicate f = StackPruningUtils.createFilterPredicate(MemPruningRules.filterPruner, (Stack)this.getCtxt().getPipelineDef().getFilterStack());
        if (f != null) {
            CollectionUtils.filter(lstRes, (Predicate)new Predicate(){

                public boolean evaluate(Object obj) {
                    return f.evaluate(obj);
                }
            });
        }
        if ((c = StackPruningUtils.createComparator(MemPruningRules.orderPruner, (Stack)this.getCtxt().getPipelineDef().getOrderStack())) != null) {
            Collections.sort(lstRes, c);
        }
        if ((samplePredicate = this.getCtxt().getPipelineDef().getSamplePredicate()) == null) {
            samplePredicate = SamplePredicates.createSamplePredicate((ESampleType)this.getCtxt().getPipelineDef().getSampleType(), (int)this.getCtxt().getPipelineDef().getSampleParam());
        }
        if (samplePredicate != null) {
            Iterator it = lstRes.iterator();
            int n = lstRes.size();
            for (int i = 0; i < n; ++i) {
                it.next();
                if (samplePredicate.evaluate(i, n)) continue;
                it.remove();
            }
        }
        if ((visitor = StackPruningUtils.createVisitor(MemPruningRules.visitorPruner, (Stack)this.getCtxt().getPipelineDef().getVisitStack())) != null) {
            int i = 0;
            for (Object obj : lstRes) {
                visitor.apply(obj, (Object)i++);
            }
        }
        if ((func = this.createTransformFunction()) != null) {
            ArrayList<Object> res1 = new ArrayList<Object>();
            int i = 0;
            for (Object obj : lstRes) {
                res1.add(func.apply(obj, (Object)i));
            }
            return res1;
        }
        return lstRes;
    }

    public T toUniqueResult() {
        List<T> res = this.toList();
        if (res.size() > 1) {
            throw new IllegalArgumentException("unique result expected, but found " + res.size());
        }
        return res.size() == 0 ? null : (T)res.get(0);
    }

    public int size() {
        return this.toList().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TPlugin plugin() {
        return (TPlugin)this.getCtxt().getPlugin();
    }
}

