/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.qlink.mem.pruning.filter;

import com.googlecode.qlink.api.functor.Aggregator;
import com.googlecode.qlink.api.functor.Predicate;
import com.googlecode.qlink.api.tuple.Pair;
import com.googlecode.qlink.core.context.blocks.FilterBlock;
import com.googlecode.qlink.core.context.enums.EFilterBlockType;
import com.googlecode.qlink.core.functor.AggregatorPredicate;
import com.googlecode.qlink.core.pruning.IPruningAction;
import com.googlecode.qlink.core.utils.SimpleAssert;
import com.googlecode.qlink.mem.utils.MemAggregationUtils;
import com.googlecode.qlink.tuples.Tuples;
import java.util.Arrays;
import java.util.List;

public class AggregatorConditionPruningAction
implements IPruningAction<EFilterBlockType, FilterBlock> {
    public List<Pair<EFilterBlockType, FilterBlock>> applyOnStack(List<Pair<EFilterBlockType, FilterBlock>> stackTop) {
        FilterBlock val = (FilterBlock)stackTop.get(0).getSecond();
        FilterBlock condition = (FilterBlock)stackTop.get(1).getSecond();
        FilterBlock aggregatorBlock = (FilterBlock)stackTop.get(2).getSecond();
        Aggregator aggregator = aggregatorBlock.getAggregator();
        if (aggregator == null) {
            SimpleAssert.notNull((Object)aggregatorBlock.getAggregatorType());
            aggregator = MemAggregationUtils.chooseAggregator(aggregatorBlock.getAggregatorType(), aggregatorBlock.getProperty());
        }
        AggregatorPredicate p = new AggregatorPredicate(aggregator, condition.getCondition(), val.getValue());
        return Arrays.asList(Tuples.tie((Object)EFilterBlockType.predicate, (Object)FilterBlock.forPredicate((Predicate)p)));
    }
}

