/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.qlink.mem.utils;

import com.googlecode.qlink.api.functor.Aggregator;
import com.googlecode.qlink.api.functor.Function;
import com.googlecode.qlink.api.functor.Function2;
import com.googlecode.qlink.api.tuple.Pair;
import com.googlecode.qlink.core.context.blocks.TransformBlock;
import com.googlecode.qlink.core.context.enums.ETransformBlockType;
import com.googlecode.qlink.core.context.enums.ETransformResultType;
import com.googlecode.qlink.core.functor.Aggregators;
import com.googlecode.qlink.core.functor.CompositeFunctionForTuple;
import com.googlecode.qlink.core.functor.Functions;
import com.googlecode.qlink.core.utils.SimpleAssert;
import com.googlecode.qlink.mem.utils.MemAggregationUtils;
import java.util.Arrays;
import java.util.Stack;

public class MemFunctionUtils {
    private MemFunctionUtils() {
    }

    public static Function2<?, Integer, ?>[] getTransformFunctions(Stack<Pair<ETransformBlockType, TransformBlock>> transformStack) {
        if (transformStack.size() == 0) {
            return null;
        }
        Function2[] functions = new Function2[transformStack.size()];
        int i = 0;
        block6: for (Pair pair : transformStack) {
            TransformBlock ts = (TransformBlock)pair.getSecond();
            switch (ts.getType()) {
                case constant: {
                    functions[i++] = Functions.adaptToFunctionWithIndex((Function)Functions.constant((Object)ts.getConstant()));
                    continue block6;
                }
                case property: {
                    functions[i++] = Functions.adaptToFunctionWithIndex((Function)Functions.propertyAccessor((String)ts.getProperty().getName(), (Class)ts.getProperty().getPropertyCls()));
                    continue block6;
                }
                case valueAggregator: {
                    Aggregator agg = MemAggregationUtils.chooseAggregator(ts.getAggregatorType(), ts.getProperty());
                    functions[i++] = Aggregators.asFunctionWithIndex(agg);
                    continue block6;
                }
                case functor: {
                    functions[i++] = Functions.adaptToFunctionWithIndex((Function)ts.getFunction());
                    continue block6;
                }
            }
            throw new IllegalArgumentException("unrecognized type " + ts.getType() + ": " + ts);
        }
        return functions;
    }

    public static Function2<?, Integer, ?> createTransformFunctionInternal(Stack<Pair<ETransformBlockType, TransformBlock>> transformStack, ETransformResultType resType, Class<?> resCls) {
        if (transformStack.size() == 0) {
            return null;
        }
        SimpleAssert.notNull((Object)resType);
        Function2<?, Integer, ?>[] functions = MemFunctionUtils.getTransformFunctions(transformStack);
        switch (resType) {
            case arrayObject: {
                return new CompositeFunctionForTuple(Arrays.asList(functions), true);
            }
            case newObject: {
                return new CompositeFunctionForTuple(Arrays.asList(functions), resCls);
            }
            case tuple: {
                if (transformStack.size() == 1) {
                    return functions[0];
                }
                return new CompositeFunctionForTuple(Arrays.asList(functions), false);
            }
        }
        throw new IllegalArgumentException("unrecognized transformation: " + resType + ", " + resCls);
    }
}

