/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.mojo;

import com.googlecode.refit.mojo.ClasspathClassLoader;
import com.googlecode.refit.runner.ReportGenerator;
import com.googlecode.refit.runner.RunnerListener;
import com.googlecode.refit.runner.TreeRunner;
import com.googlecode.refit.runner.jaxb.TestResult;
import java.io.File;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class FitRunnerMojo
extends AbstractMojo
implements RunnerListener {
    private static final String COMMA = ",";
    private static final String EXECUTION_PARAMETERS = "sourceDirectory={0}, caseSensitive={1}, sourceIncludes={2}, sourceExcludes={3}, parseTags={4}, outputDirectory={5}, ignoreFailures={6}";
    protected List<String> classpathElements;
    protected String sourceDirectory;
    protected boolean caseSensitive;
    protected String sourceIncludes;
    protected String sourceExcludes;
    protected String[] parseTags = new String[]{"table", "tr", "td"};
    protected String outputDirectory;
    protected boolean ignoreFailures;
    protected boolean skip;
    private ClasspathClassLoader testClassLoader;
    private ReportGenerator reportGenerator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String executionParameters = MessageFormat.format(EXECUTION_PARAMETERS, this.sourceDirectory, this.caseSensitive, this.sourceIncludes, this.sourceExcludes, Arrays.asList(this.parseTags), this.outputDirectory, this.ignoreFailures);
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Fit tests");
            return;
        }
        this.getLog().debug((CharSequence)("Executing FitRunner with parameters " + executionParameters));
        System.setProperty("fit.inputDir", this.sourceDirectory);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getTestClassLoader());
            this.run(this.sourceDirectory, this.caseSensitive, this.sourceIncludes, this.sourceExcludes, this.outputDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute FitRunner with parameters " + executionParameters, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected ClasspathClassLoader getTestClassLoader() {
        if (this.testClassLoader == null) {
            try {
                this.testClassLoader = new ClasspathClassLoader(this.classpathElements);
            }
            catch (MalformedURLException exc) {
                throw new IllegalStateException("error in classpath", exc);
            }
            this.getLog().debug((CharSequence)("Created test path classloader with classpathElements " + this.classpathElements));
        }
        return this.testClassLoader;
    }

    protected void run(String sourceDirectory, boolean caseSensitive, String sourceIncludes, String sourceExcludes, String outputDirectory) throws Exception {
        File inputDir = new File(sourceDirectory);
        File outputDir = new File(outputDirectory);
        String[] includes = null;
        String[] excludes = null;
        if (sourceIncludes != null) {
            this.getLog().debug((CharSequence)("Setting includes " + sourceIncludes));
            includes = sourceIncludes.split(COMMA);
        }
        if (sourceExcludes != null) {
            this.getLog().debug((CharSequence)("Setting excludes " + sourceExcludes));
            excludes = sourceExcludes.split(COMMA);
        }
        this.reportGenerator = new ReportGenerator(inputDir, outputDir);
        TreeRunner runner = new TreeRunner(inputDir, outputDir, includes, excludes, (RunnerListener)this);
        runner.run();
    }

    public void beforeTest(String testPath) {
        this.getLog().debug((CharSequence)("running Fit test " + testPath));
        this.reportGenerator.beforeTest(testPath);
    }

    public void afterTest(TestResult result) {
        if (!result.isPassed()) {
            String message = String.format("Fit test %s failed with %d right, %d wrong, %d ignored, %d exceptions", result.getPath(), result.getRight(), result.getWrong(), result.getIgnored(), result.getExceptions());
            if (this.ignoreFailures) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new IllegalStateException(message);
            }
        }
        this.reportGenerator.afterTest(result);
    }

    public void afterSuite() {
        this.getLog().debug((CharSequence)"writing reports");
        this.reportGenerator.afterSuite();
    }
}

