/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.osgi;

import com.googlecode.refit.osgi.FileRunner;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;

public class TreeRunner {
    public static final String DEFAULT_INCLUDE = "**/*.html";
    private File inputDir;
    private File outputDir;
    private String[] includes;
    private String[] excludes;

    public TreeRunner(File inputDir, File outputDir) {
        this(inputDir, outputDir, DEFAULT_INCLUDE);
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes) {
        this(inputDir, outputDir, includes, null);
    }

    public TreeRunner(File inputDir, File outputDir, String include) {
        this(inputDir, outputDir, new String[]{include}, null);
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes, String[] excludes) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean run() {
        assert (this.inputDir != null);
        assert (this.outputDir != null);
        assert (this.includes != null);
        System.setProperty("fit.inputDir", this.inputDir.getPath());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDir);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        assert (files != null);
        if (files.length == 0) {
            throw new RuntimeException("no matching input files");
        }
        boolean success = true;
        for (String testPath : files) {
            FileRunner runner = new FileRunner(this.inputDir, this.outputDir, testPath);
            boolean passed = runner.run();
            success &= passed;
        }
        return success;
    }
}

