/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.osgi;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;

public class FileRunner {
    private File inputDir;
    private File outputDir;
    private String testPath;
    private Fixture fixture;

    public FileRunner(File inputDir, File outputDir, String testPath) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.testPath = testPath;
    }

    public boolean run() {
        File inputFile = new File(this.inputDir, this.testPath);
        File outputFile = new File(this.outputDir, this.testPath);
        System.setProperty("fit.currentTest", this.testPath);
        try {
            this.ensureParentDirExists(outputFile);
            return this.run(inputFile, outputFile);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        catch (ParseException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void ensureParentDirExists(File outputFile) throws IOException {
        File parentDir = outputFile.getParentFile();
        if (parentDir.exists()) {
            if (!parentDir.isDirectory()) {
                throw new IOException(parentDir + " is not a directory");
            }
        } else if (!parentDir.mkdirs()) {
            throw new IOException("cannot create " + parentDir);
        }
    }

    private boolean run(File in, File out) throws IOException, ParseException {
        return this.run(new FileReader(in), new FileWriter(out));
    }

    private boolean run(Reader reader, Writer writer) throws IOException, ParseException {
        String input = this.read(reader);
        Parse tables = new Parse(input);
        this.fixture = new Fixture();
        this.fixture.doTables(tables);
        PrintWriter output = new PrintWriter(writer);
        tables.print(output);
        output.flush();
        return this.passed(this.fixture);
    }

    private boolean passed(Fixture fixture) {
        return fixture.getCounts().wrong <= 0 && fixture.getCounts().exceptions <= 0;
    }

    private String read(Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        StringBuffer sb = new StringBuffer();
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            line = br.readLine();
        }
        in.close();
        return sb.toString();
    }
}

