/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.runner;

import com.googlecode.refit.runner.FileRunner;
import com.googlecode.refit.runner.jaxb.ObjectFactory;
import com.googlecode.refit.runner.jaxb.Summary;
import com.googlecode.refit.runner.jaxb.TestResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ReportIO {
    public static final String FIT_REPORT_XML = "fit-report.xml";
    public static final String FIT_REPORT_HTML = "index.html";
    public static final String FIT_CSS = "fit.css";
    public static final String CONTEXT_PATH = "com.googlecode.refit.runner.jaxb";
    private Summary summary;
    private PrintWriter writer;

    public ReportIO() {
    }

    public ReportIO(Summary summary) {
        this.summary = summary;
    }

    public void writeCss(File css) throws IOException {
        this.writer = new PrintWriter(css, "UTF-8");
        InputStream is = this.getClass().getResourceAsStream("/css/fit.css");
        InputStreamReader reader = new InputStreamReader(is);
        String content = FileRunner.read(reader);
        this.writer.write(content);
        this.writer.close();
    }

    public void writeXml(File report) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((String)CONTEXT_PATH);
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ObjectFactory factory = new ObjectFactory();
        marshaller.marshal(factory.createSummary(this.summary), report);
    }

    public void writeHtml(File report) throws IOException {
        this.writer = new PrintWriter(report, "UTF-8");
        this.writer.println("<html><head><title>Fit Summary</title>");
        this.writer.println("<link rel='stylesheet' type='text/css' href='fit.css'>");
        this.writer.println("</head><body>");
        this.writer.println("<table class='summary'>");
        this.writeTableHeaderRow();
        this.writeTotals();
        for (TestResult testResult : this.summary.getTest()) {
            this.writeTableRow(testResult);
        }
        this.writer.println("</table>");
        this.writer.println("</body></html>");
        this.writer.close();
    }

    private void writeTotals() {
        this.writer.println("<tr>");
        this.writeTableCell("total", "Total (" + this.summary.getNumTests() + " tests)");
        this.writeTableCell("right", this.summary.getRight());
        this.writeTableCell("wrong", this.summary.getWrong());
        this.writeTableCell("ignored", this.summary.getIgnored());
        this.writeTableCell("exceptions", this.summary.getExceptions());
        this.writeTableCell("sum", this.getSummarySum());
        this.writer.println("</tr>");
    }

    private int getSummarySum() {
        return this.summary.getRight() + this.summary.getWrong() + this.summary.getIgnored() + this.summary.getExceptions();
    }

    private void writeTableHeaderRow() {
        this.writer.println("<tr>");
        this.writeTableHeaderCell("Test");
        this.writeTableHeaderCell("Right");
        this.writeTableHeaderCell("Wrong");
        this.writeTableHeaderCell("Ignored");
        this.writeTableHeaderCell("Exceptions");
        this.writeTableHeaderCell("Sum");
        this.writer.println("</tr>");
    }

    private void writeTableHeaderCell(String text) {
        this.writer.println("<th>" + text + "</th>");
    }

    private void writeTableRow(TestResult testResult) {
        this.writer.println("<tr>");
        this.writeLinkedTableCell(testResult.getPath());
        this.writeTableCell("right", testResult.getRight());
        this.writeTableCell("wrong", testResult.getWrong());
        this.writeTableCell("ignored", testResult.getIgnored());
        this.writeTableCell("exceptions", testResult.getExceptions());
        this.writeTableCell("sum", this.getSum(testResult));
        this.writer.println("</tr>");
    }

    private int getSum(TestResult testResult) {
        return testResult.getRight() + testResult.getWrong() + testResult.getIgnored() + testResult.getExceptions();
    }

    private void writeTableCell(String style, String text) {
        this.writer.println("<td class='" + style + "'>" + text + "</td>");
    }

    private void writeLinkedTableCell(String text) {
        this.writer.println("<td><a href='" + text + "'>" + text + "</a></td>");
    }

    private void writeTableCell(String style, int count) {
        String actualStyle = count == 0 ? "none" : style;
        this.writer.println("<td class='" + actualStyle + "'>" + count + "</td>");
    }

    public Summary readXml(InputStream is) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        JAXBElement summaryRoot = (JAXBElement)unmarshaller.unmarshal(is);
        Summary summary = (Summary)summaryRoot.getValue();
        return summary;
    }

    public static String format(TestResult result) {
        return String.format("%d right, %d wrong, %d ignored, %d exceptions", result.getRight(), result.getWrong(), result.getIgnored(), result.getExceptions());
    }
}

