/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.runner;

import com.googlecode.refit.runner.RunnerListener;
import com.googlecode.refit.runner.jaxb.TestResult;
import java.util.ArrayList;
import java.util.List;

public class CompositeRunnerListener
implements RunnerListener {
    private List<RunnerListener> listeners = new ArrayList<RunnerListener>();

    public void addListener(RunnerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RunnerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void beforeTest(String testPath) {
        for (RunnerListener listener : this.listeners) {
            listener.beforeTest(testPath);
        }
    }

    @Override
    public void afterTest(TestResult result) {
        for (RunnerListener listener : this.listeners) {
            listener.afterTest(result);
        }
    }

    @Override
    public void afterSuite() {
        for (RunnerListener listener : this.listeners) {
            listener.afterSuite();
        }
    }
}

