/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.runner;

import com.googlecode.refit.runner.FitException;
import com.googlecode.refit.runner.ReportIO;
import com.googlecode.refit.runner.RunnerListener;
import com.googlecode.refit.runner.jaxb.Summary;
import com.googlecode.refit.runner.jaxb.TestResult;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

public class ReportGenerator
implements RunnerListener {
    private Summary summary = new Summary();
    private int totalRight;
    private int totalWrong;
    private int totalIgnored;
    private int totalExceptions;
    private File outputDir;

    public ReportGenerator(File inputDir, File outputDir) {
        this.outputDir = outputDir;
        this.summary.setInputDir(inputDir.getPath());
        this.summary.setOutputDir(outputDir.getPath());
    }

    @Override
    public void beforeTest(String testPath) {
    }

    @Override
    public void afterTest(TestResult result) {
        this.summary.getTest().add(result);
        this.totalRight += result.getRight();
        this.totalWrong += result.getWrong();
        this.totalIgnored += result.getIgnored();
        this.totalExceptions += result.getExceptions();
    }

    public void createReports() {
        this.buildSummary();
        this.printSummary();
    }

    public Summary getSummary() {
        return this.summary;
    }

    private void buildSummary() {
        this.summary.setNumTests(this.summary.getTest().size());
        boolean success = this.totalExceptions == 0 && this.totalWrong == 0;
        this.summary.setPassed(success);
        this.summary.setRight(this.totalRight);
        this.summary.setWrong(this.totalWrong);
        this.summary.setIgnored(this.totalIgnored);
        this.summary.setExceptions(this.totalExceptions);
    }

    private void printSummary() {
        ReportIO writer = new ReportIO(this.summary);
        File xmlReport = new File(this.outputDir, "fit-report.xml");
        File htmlReport = new File(this.outputDir, "index.html");
        File css = new File(this.outputDir, "fit.css");
        try {
            writer.writeXml(xmlReport);
            writer.writeHtml(htmlReport);
            writer.writeCss(css);
        }
        catch (JAXBException exc) {
            throw new FitException(exc);
        }
        catch (IOException exc) {
            throw new FitException(exc);
        }
    }

    @Override
    public void afterSuite() {
        this.createReports();
    }
}

