/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.refit.runner;

import com.googlecode.refit.runner.DefaultRunnerListener;
import com.googlecode.refit.runner.FileRunner;
import com.googlecode.refit.runner.FitException;
import com.googlecode.refit.runner.RunnerListener;
import com.googlecode.refit.runner.jaxb.TestResult;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;

public class TreeRunner {
    public static final String DEFAULT_INCLUDE = "**/*.html";
    private File inputDir;
    private File outputDir;
    private String[] includes;
    private String[] excludes;
    private RunnerListener listener;
    private boolean success;

    public TreeRunner(File inputDir, File outputDir) {
        this(inputDir, outputDir, DEFAULT_INCLUDE);
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes) {
        this(inputDir, outputDir, includes, (String[])null);
    }

    public TreeRunner(File inputDir, File outputDir, String include) {
        this(inputDir, outputDir, new String[]{include}, (String[])null);
    }

    public TreeRunner(File inputDir, File outputDir, RunnerListener listener) {
        this(inputDir, outputDir, DEFAULT_INCLUDE, listener);
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes, RunnerListener listener) {
        this(inputDir, outputDir, includes, null, listener);
    }

    public TreeRunner(File inputDir, File outputDir, String include, RunnerListener listener) {
        this(inputDir, outputDir, new String[]{include}, null, listener);
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes, String[] excludes) {
        this(inputDir, outputDir, includes, excludes, new DefaultRunnerListener());
    }

    public TreeRunner(File inputDir, File outputDir, String[] includes, String[] excludes, RunnerListener listener) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.includes = includes;
        this.excludes = excludes;
        this.listener = listener;
    }

    public boolean run() {
        assert (this.inputDir != null);
        assert (this.outputDir != null);
        assert (this.includes != null);
        System.setProperty("fit.inputDir", this.inputDir.getPath());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDir);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        assert (files != null);
        if (files.length == 0) {
            throw new FitException("no matching input files");
        }
        for (String testPath : files) {
            this.runSingleTest(testPath);
        }
        this.listener.afterSuite();
        return this.success;
    }

    private void runSingleTest(String testPath) {
        this.listener.beforeTest(testPath);
        FileRunner runner = new FileRunner(this.inputDir, this.outputDir, testPath);
        boolean passed = runner.run();
        this.success &= passed;
        TestResult result = runner.getResult();
        this.listener.afterTest(result);
    }
}

