/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.rocoto.converters;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeConverter;
import com.googlecode.rocoto.converters.BitSetConverter;
import com.googlecode.rocoto.converters.CharsetConverter;
import com.googlecode.rocoto.converters.CurrencyConverter;
import com.googlecode.rocoto.converters.DateConverter;
import com.googlecode.rocoto.converters.FileConverter;
import com.googlecode.rocoto.converters.LocaleConverter;
import com.googlecode.rocoto.converters.NumberConverter;
import com.googlecode.rocoto.converters.PatternConverter;
import com.googlecode.rocoto.converters.PropertiesConverter;
import com.googlecode.rocoto.converters.SQLDateTimeConverter;
import com.googlecode.rocoto.converters.TimeZoneConverter;
import com.googlecode.rocoto.converters.URIConverter;
import com.googlecode.rocoto.converters.URLConverter;
import com.googlecode.rocoto.converters.UUIDConverter;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertersModule
extends AbstractModule {
    private final Map<Matcher<? super TypeLiteral<?>>, TypeConverter> converters = new HashMap();

    public ConvertersModule() {
        this.registerConverter(BitSet.class, (TypeConverter)new BitSetConverter());
        this.registerConverter(Charset.class, (TypeConverter)new CharsetConverter());
        this.registerConverter(Currency.class, (TypeConverter)new CurrencyConverter());
        this.registerConverter(File.class, (TypeConverter)new FileConverter());
        this.registerConverter(Locale.class, (TypeConverter)new LocaleConverter());
        this.registerConverter(Pattern.class, (TypeConverter)new PatternConverter());
        this.registerConverter(Properties.class, (TypeConverter)new PropertiesConverter());
        this.registerConverter(TimeZone.class, (TypeConverter)new TimeZoneConverter());
        this.registerConverter(URL.class, (TypeConverter)new URLConverter());
        this.registerConverter(URI.class, (TypeConverter)new URIConverter());
        this.registerConverter(UUID.class, (TypeConverter)new UUIDConverter());
        NumberConverter numberConverter = new NumberConverter();
        this.registerConverter(BigDecimal.class, (TypeConverter)numberConverter);
        this.registerConverter(BigInteger.class, (TypeConverter)numberConverter);
        DateConverter dateConverter = new DateConverter();
        this.registerConverter(Calendar.class, (TypeConverter)dateConverter);
        this.registerConverter(java.util.Date.class, (TypeConverter)dateConverter);
        SQLDateTimeConverter sqlDateTimeConverter = new SQLDateTimeConverter();
        this.registerConverter(Date.class, (TypeConverter)sqlDateTimeConverter);
        this.registerConverter(Time.class, (TypeConverter)sqlDateTimeConverter);
        this.registerConverter(Timestamp.class, (TypeConverter)sqlDateTimeConverter);
    }

    public void registerConverter(Class<?> type, TypeConverter typeConverter) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' nust not be null");
        }
        if (typeConverter == null) {
            throw new IllegalArgumentException("Argument 'typeConverter' nust not be null");
        }
        this.registerConverter(TypeLiteral.get(type), typeConverter);
    }

    public void registerConverter(TypeLiteral<?> typeLiteral, TypeConverter typeConverter) {
        if (typeLiteral == null) {
            throw new IllegalArgumentException("Argument 'typeLiteral' nust not be null");
        }
        if (typeConverter == null) {
            throw new IllegalArgumentException("Argument 'typeConverter' nust not be null");
        }
        this.registerConverter(Matchers.only(typeLiteral), typeConverter);
    }

    public void registerConverter(Matcher<? super TypeLiteral<?>> matcher, TypeConverter typeConverter) {
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 'matcher' nust not be null");
        }
        if (typeConverter == null) {
            throw new IllegalArgumentException("Argument 'typeConverter' nust not be null");
        }
        this.converters.put(matcher, typeConverter);
    }

    public <T extends TypeConverter> T lookup(Class<?> type, Class<T> converterType) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' nust not be null");
        }
        return this.lookup(TypeLiteral.get(type), converterType);
    }

    public <T extends TypeConverter> T lookup(TypeLiteral<?> typeLiteral, Class<T> converterType) {
        if (typeLiteral == null) {
            throw new IllegalArgumentException("Argument 'typeLiteral' nust not be null");
        }
        return this.lookup(Matchers.only(typeLiteral), converterType);
    }

    public <T extends TypeConverter> T lookup(Matcher<? super TypeLiteral<?>> matcher, Class<T> converterType) {
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 'matcher' nust not be null");
        }
        TypeConverter converter = this.converters.get(matcher);
        if (converter != null && converterType.isInstance(converter)) {
            return (T)((TypeConverter)converterType.cast(converter));
        }
        return null;
    }

    protected void configure() {
        for (Map.Entry<Matcher<TypeLiteral<?>>, TypeConverter> converter : this.converters.entrySet()) {
            this.binder().convertToTypes(converter.getKey(), converter.getValue());
        }
    }
}

