/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.rocoto.converters;

import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.spi.TypeConverter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NumberConverter
implements TypeConverter {
    NumberConverter() {
    }

    public Object convert(String value, TypeLiteral<?> toType) {
        Class type = MoreTypes.getRawType((Type)toType.getType());
        if (BigDecimal.class == type) {
            return new BigDecimal(value);
        }
        if (BigInteger.class == type) {
            return new BigInteger(value);
        }
        throw new IllegalArgumentException("Impossible to convert '" + value + "' to '" + type.getName() + "'");
    }

    public String toString() {
        return "TypeConverter<java.math.BigDecimal | java.math.BigInteger>";
    }
}

