/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.rocoto.converters;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesConverter
implements TypeConverter {
    private static final String PROPERTIES_ENCODING = "ISO-8859-1";

    public Object convert(String value, TypeLiteral<?> toType) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(value.getBytes(PROPERTIES_ENCODING)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse " + value + "' into Properties", e);
        }
        return properties;
    }

    public String toString() {
        return "TypeConverter<java.util.Properties>";
    }
}

