/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.rocoto.converters;

import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.spi.TypeConverter;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLDateTimeConverter
implements TypeConverter {
    public Object convert(String value, TypeLiteral<?> toType) {
        Class type = MoreTypes.getRawType((Type)toType.getType());
        if (type == Date.class) {
            try {
                return Date.valueOf(value);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type == Time.class) {
            try {
                return Time.valueOf(value);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type == Timestamp.class) {
            try {
                return Timestamp.valueOf(value);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        throw new IllegalArgumentException("Type '" + type.getName() + " not supported in this version");
    }

    public String toString() {
        return "TypeConverter<java.sql.Date | java.sql.Time | java.sql.Timestamp>";
    }
}

