/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.graph;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.GraphLookAndFeel;
import com.googlecode.sarasvati.visual.common.GraphSceneImpl;
import com.googlecode.sarasvati.visual.graph.GraphLayoutNode;
import com.googlecode.sarasvati.visual.graph.GraphLayoutTree;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SarasvatiGraphScene
extends GraphSceneImpl<Node, Arc> {
    protected GraphLookAndFeel lookAndFeel;
    protected static final Font ARC_LABEL_FONT = Font.decode("serif bold 11");

    public SarasvatiGraphScene(Graph graph, GraphLookAndFeel lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
        if (graph != null) {
            Widget widget;
            GraphLayoutTree graphTree = new GraphLayoutTree(graph);
            for (Node node : graph.getNodes()) {
                widget = this.addNode(node);
                GraphLayoutNode<Node> treeNode = graphTree.getTreeNode(node);
                Rectangle bounds = widget.getPreferredBounds();
                Point origin = new Point(treeNode.getOriginX(bounds.width), treeNode.getOriginY(bounds.height));
                widget.setPreferredLocation(origin);
                widget.resolveBounds(origin, null);
            }
            for (Arc arc : graph.getArcs()) {
                if (!lookAndFeel.drawSelfArcs(arc) && arc.getStartNode().equals(arc.getEndNode())) continue;
                widget = (ConnectionWidget)this.addEdge(arc);
                this.setEdgeSource(arc, arc.getStartNode());
                this.setEdgeTarget(arc, arc.getEndNode());
                widget.resolveBounds(null, null);
                if (arc.getName() == null || !lookAndFeel.drawArcLabels(arc)) continue;
                LabelWidget arcLabel = new LabelWidget((Scene)this, arc.getName());
                arcLabel.setFont(ARC_LABEL_FONT);
                arcLabel.setForeground(Color.BLUE);
                arcLabel.setOpaque(true);
                widget.addChild((Widget)arcLabel);
                widget.setConstraint((Widget)arcLabel, LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_SOURCE, 5);
            }
            this.revalidate();
        }
    }

    @Override
    protected Widget widgetForNode(Node node) {
        return this.lookAndFeel.newWidget(node, this);
    }
}

