/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.process;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.ArcToken;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.ProcessLookAndFeel;
import com.googlecode.sarasvati.visual.graph.GraphLayoutTree;
import com.googlecode.sarasvati.visual.process.ProcessTreeArc;
import com.googlecode.sarasvati.visual.process.ProcessTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcessTree {
    protected ProcessLookAndFeel lookAndFeel;
    protected GraphLayoutTree graphTree;
    protected Map<NodeToken, ProcessTreeNode> nodeTokenMap = new HashMap<NodeToken, ProcessTreeNode>();
    protected Map<Node, ProcessTreeNode> nodeMap = new HashMap<Node, ProcessTreeNode>();
    protected List<NodeToken> sortedTokenList = null;
    protected List<ProcessTreeNode> queue = new LinkedList<ProcessTreeNode>();

    protected ProcessTreeNode getProcessTreeNode(ProcessTreeNode parent, Node node) {
        NodeToken parentToken = parent.getParentToken();
        NodeToken current = null;
        int currentDistance = 0;
        ParentTree parentTree = null;
        for (NodeToken token : this.sortedTokenList) {
            int distance;
            if (!token.getNode().equals(node)) continue;
            if (current == null) {
                current = token;
                continue;
            }
            if (parentTree == null) {
                parentTree = new ParentTree(parentToken);
                currentDistance = parentTree.getDistance(new ParentTree(current));
            }
            if ((distance = parentTree.getDistance(new ParentTree(token))) >= currentDistance) continue;
            current = token;
            currentDistance = distance;
        }
        if (current != null) {
            return this.nodeTokenMap.get(current);
        }
        return this.getNonTokenProcessTreeNode(parent, node);
    }

    public ProcessTreeNode getNonTokenProcessTreeNode(ProcessTreeNode parent, Node node) {
        ProcessTreeNode endNode = this.nodeMap.get(node);
        if (endNode == null) {
            endNode = new ProcessTreeNode(parent, node);
            this.nodeMap.put(node, endNode);
            this.queue.add(endNode);
        }
        return endNode;
    }

    public boolean isBackArc(Arc arc) {
        return this.lookAndFeel.isBackArc(arc, this.graphTree.isBackArc(arc.getStartNode(), arc.getEndNode()));
    }

    public ProcessTree(GraphProcess process, ProcessLookAndFeel lookAndFeel) {
        boolean allInputsProcessed;
        List<ProcessTreeNode> prevLayer;
        Graph graph = process.getGraph();
        this.graphTree = new GraphLayoutTree(graph);
        this.lookAndFeel = lookAndFeel;
        for (NodeToken token : process.getNodeTokens()) {
            this.nodeTokenMap.put(token, new ProcessTreeNode(token));
        }
        this.sortedTokenList = new ArrayList<NodeToken>(process.getNodeTokens());
        Collections.sort(this.sortedTokenList, new Comparator<NodeToken>(){

            @Override
            public int compare(NodeToken o1, NodeToken o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        for (NodeToken token : this.nodeTokenMap.keySet()) {
            ProcessTreeNode childNode = this.nodeTokenMap.get(token);
            for (ArcToken parentArc : token.getParentTokens()) {
                ProcessTreeNode parentNode = this.nodeTokenMap.get(parentArc.getParentToken());
                ProcessTreeArc processTreeArc = new ProcessTreeArc(parentArc, parentNode, childNode);
                parentNode.addChild(processTreeArc);
                childNode.addParent(processTreeArc);
            }
        }
        List<ProcessTreeNode> nextLayer = new LinkedList<ProcessTreeNode>();
        LinkedList<LinkedList<ProcessTreeNode>> layers = new LinkedList<LinkedList<ProcessTreeNode>>();
        HashSet<ProcessTreeNode> processed = new HashSet<ProcessTreeNode>();
        for (ProcessTreeNode ptNode : this.nodeTokenMap.values()) {
            if (!ptNode.isStartTokenNode()) continue;
            ptNode.setDepth(0);
            ptNode.addToLayer(nextLayer);
            processed.add(ptNode);
        }
        int depth = 1;
        while (!nextLayer.isEmpty()) {
            layers.add((LinkedList<ProcessTreeNode>)nextLayer);
            prevLayer = nextLayer;
            nextLayer = new LinkedList();
            for (ProcessTreeNode treeNode : prevLayer) {
                for (ProcessTreeArc ptArc : treeNode.getChildren()) {
                    if (processed.contains(ptArc.getChild())) continue;
                    ProcessTreeNode childNode = ptArc.getChild();
                    allInputsProcessed = true;
                    for (ProcessTreeArc parentArc : childNode.getParents()) {
                        if (processed.contains(parentArc.getParent()) && !nextLayer.contains(parentArc.getParent())) continue;
                        allInputsProcessed = false;
                        break;
                    }
                    if (!allInputsProcessed) continue;
                    childNode.setDepth(depth);
                    childNode.addToLayer(nextLayer);
                    processed.add(childNode);
                }
            }
            ++depth;
        }
        for (ArcToken arcToken : process.getActiveArcTokens()) {
            ProcessTreeArc ptArc;
            ProcessTreeNode parentNode = this.nodeTokenMap.get(arcToken.getParentToken());
            ProcessTreeNode childNode = this.getNonTokenProcessTreeNode(parentNode, arcToken.getArc().getEndNode());
            ptArc = new ProcessTreeArc(arcToken, parentNode, childNode);
            parentNode.addChild(ptArc);
            childNode.addParent(ptArc);
        }
        for (ProcessTreeNode ptNode : this.nodeTokenMap.values()) {
            for (Arc arc : graph.getOutputArcs(ptNode.getNode())) {
                if (ptNode.isTokenOnArc(arc) || arc.isSelfArc()) continue;
                ProcessTreeNode child = ptNode.getToken().isComplete() || this.isBackArc(arc) ? this.getProcessTreeNode(ptNode, arc.getEndNode()) : this.getNonTokenProcessTreeNode(ptNode, arc.getEndNode());
                ProcessTreeArc arcTokenWrapper = new ProcessTreeArc(arc, ptNode, child);
                ptNode.addChild(arcTokenWrapper);
                child.addParent(arcTokenWrapper);
            }
        }
        while (!this.queue.isEmpty()) {
            ProcessTreeNode ptNode;
            ptNode = this.queue.remove(0);
            for (Arc arc : graph.getOutputArcs(ptNode.getNode())) {
                ProcessTreeNode child = null;
                child = arc.isSelfArc() ? ptNode : (this.isBackArc(arc) ? this.getProcessTreeNode(ptNode, arc.getEndNode()) : this.getNonTokenProcessTreeNode(ptNode, arc.getEndNode()));
                ProcessTreeArc arcTokenWrapper = new ProcessTreeArc(arc, ptNode, child);
                ptNode.addChild(arcTokenWrapper);
                child.addParent(arcTokenWrapper);
            }
        }
        processed.clear();
        nextLayer = (List)layers.get(0);
        processed.addAll(nextLayer);
        depth = 1;
        while (!nextLayer.isEmpty()) {
            prevLayer = nextLayer;
            nextLayer = layers.size() > depth ? (List)layers.get(depth) : new LinkedList();
            for (ProcessTreeNode treeNode : prevLayer) {
                for (ProcessTreeArc ptArc : treeNode.getChildren()) {
                    ProcessTreeNode child = ptArc.getChild();
                    if (processed.contains(child)) continue;
                    if (child.getDepth() >= 0) {
                        processed.add(child);
                        continue;
                    }
                    allInputsProcessed = true;
                    for (ProcessTreeArc parentArc : child.getParents()) {
                        if (processed.contains(parentArc.getParent()) && !nextLayer.contains(parentArc.getParent()) || this.isParentAlsoChild(parentArc.getParent(), child)) continue;
                        allInputsProcessed = false;
                        break;
                    }
                    if (!allInputsProcessed) continue;
                    child.setDepth(depth);
                    child.addToLayer(nextLayer);
                    processed.add(child);
                }
            }
            ++depth;
        }
    }

    private boolean isParentAlsoChild(ProcessTreeNode parent, ProcessTreeNode child) {
        HashSet<ProcessTreeNode> processed = new HashSet<ProcessTreeNode>();
        LinkedList<ProcessTreeNode> checkQueue = new LinkedList<ProcessTreeNode>();
        processed.add(parent);
        checkQueue.addAll(parent.getNodeParents());
        while (!checkQueue.isEmpty()) {
            ProcessTreeNode node = (ProcessTreeNode)checkQueue.remove();
            if (node.equals(child)) {
                return true;
            }
            processed.add(node);
            for (ProcessTreeNode input : node.getNodeParents()) {
                if (processed.contains(input)) continue;
                checkQueue.add(input);
            }
        }
        return false;
    }

    public Iterable<ProcessTreeNode> getProcessTreeNodes() {
        ArrayList<ProcessTreeNode> result = new ArrayList<ProcessTreeNode>(this.nodeTokenMap.size() + this.nodeMap.size());
        result.addAll(this.nodeTokenMap.values());
        result.addAll(this.nodeMap.values());
        return result;
    }

    private static class ParentTree {
        protected List<List<NodeToken>> tree = new LinkedList<List<NodeToken>>();

        public ParentTree(NodeToken token) {
            HashSet<NodeToken> processed = new HashSet<NodeToken>();
            LinkedList<NodeToken> nextLayer = new LinkedList<NodeToken>();
            nextLayer.add(token);
            while (!nextLayer.isEmpty()) {
                this.tree.add(nextLayer);
                LinkedList<NodeToken> prevLayer = nextLayer;
                nextLayer = new LinkedList();
                for (NodeToken ancestor : prevLayer) {
                    for (ArcToken arcToken : ancestor.getParentTokens()) {
                        if (processed.contains(arcToken.getParentToken())) continue;
                        nextLayer.add(arcToken.getParentToken());
                        processed.add(arcToken.getParentToken());
                    }
                }
            }
            this.tree.remove(0);
        }

        public int getDistance(ParentTree other) {
            int localDepth = 0;
            for (List<NodeToken> localLayer : this.tree) {
                int otherDepth = 0;
                for (List<NodeToken> otherLayer : other.tree) {
                    if (!Collections.disjoint(localLayer, otherLayer)) {
                        return localDepth + otherDepth;
                    }
                    ++otherDepth;
                }
                ++localDepth;
            }
            return Integer.MAX_VALUE;
        }
    }
}

