/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.util;

import java.awt.Font;
import java.awt.Graphics;

public class FontUtil {
    public static void setSizedFont(Graphics g, String text, float maxFontSize, int maxWidth) {
        if ((float)g.getFont().getSize() != maxFontSize) {
            Font newFont = g.getFont().deriveFont(maxFontSize);
            g.setFont(newFont);
        }
        float currentSize = maxFontSize;
        while (g.getFontMetrics().getStringBounds(text, g).getWidth() > (double)maxWidth) {
            g.setFont(g.getFont().deriveFont(currentSize -= 1.0f));
        }
    }

    public static String[] split(String text) {
        String[] lines = text.split(" ");
        if (lines.length < 3) {
            return lines;
        }
        String fst = lines[0];
        String snd = lines[lines.length - 1];
        for (int i = 1; i < lines.length - 1; ++i) {
            String cur = lines[i];
            String tmp1 = fst + " " + cur;
            String tmp2 = FontUtil.concat(lines, i, " ");
            if (tmp1.length() >= tmp2.length()) {
                snd = tmp2;
                break;
            }
            fst = tmp1;
        }
        return new String[]{fst, snd};
    }

    public static String concat(String[] str, int start, String middle) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < str.length; ++i) {
            buf.append(str[i]);
            if (i == str.length - 1) continue;
            buf.append(middle);
        }
        return buf.toString();
    }
}

