/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.GraphLookAndFeel;
import com.googlecode.sarasvati.visual.GraphToImageMap;
import com.googlecode.sarasvati.visual.graph.SarasvatiGraphScene;
import com.googlecode.sarasvati.visual.util.HoverFunctionAdapter;
import com.googlecode.sarasvati.visual.util.HrefFunctionAdapter;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class GraphImageMapCreator {
    protected String mapContents;
    protected BufferedImage image;

    public GraphImageMapCreator(Graph graph, GraphToImageMap graphToImageMap) {
        this.generateMapAndImage(graph, graphToImageMap);
    }

    protected void generateMapAndImage(Graph graph, final GraphToImageMap graphToImageMap) {
        GraphLookAndFeel lookAndFeelAdapter = new GraphLookAndFeel(){

            @Override
            public boolean drawArcLabels(Arc arc) {
                return graphToImageMap.drawArcLabels(arc);
            }

            @Override
            public boolean drawSelfArcs(Arc arc) {
                return false;
            }

            @Override
            public Widget newWidget(Node node, SarasvatiGraphScene scene) {
                Icon icon = graphToImageMap.iconForNode(node);
                JLabel label = new JLabel(icon);
                label.setSize(icon.getIconWidth(), icon.getIconHeight());
                return new ComponentWidget((Scene)scene, (Component)label);
            }
        };
        SarasvatiGraphScene graphScene = new SarasvatiGraphScene(graph, lookAndFeelAdapter);
        graphScene.setupForExportOnHeadless();
        StringBuilder buf = new StringBuilder(1024);
        HrefFunctionAdapter hrefMapper = new HrefFunctionAdapter(graphToImageMap);
        HoverFunctionAdapter hoverMapper = new HoverFunctionAdapter(graphToImageMap);
        this.image = graphScene.export(buf, hrefMapper, hoverMapper);
        this.mapContents = buf.toString();
    }

    public String getMapContents() {
        return this.mapContents;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void writeImageToFile(String imageFormat, String imageFileName) throws IOException {
        ImageIO.write((RenderedImage)this.image, imageFormat, new File(imageFileName));
        this.image.flush();
    }
}

