/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.visual.ProcessLookAndFeel;
import com.googlecode.sarasvati.visual.ProcessToImageMap;
import com.googlecode.sarasvati.visual.process.SarasvatiProcessScene;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;
import com.googlecode.sarasvati.visual.util.ProcessHoverFunctionAdapter;
import com.googlecode.sarasvati.visual.util.ProcessHrefFunctionAdapter;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ProcessImageMapCreator {
    protected String mapContents;
    protected BufferedImage image;

    public ProcessImageMapCreator(GraphProcess process, ProcessToImageMap processToImageMap) {
        this.generateMapAndImage(process, processToImageMap);
    }

    protected void generateMapAndImage(GraphProcess process, final ProcessToImageMap processToImageMap) {
        ProcessLookAndFeel lookAndFeelAdapter = new ProcessLookAndFeel(){

            @Override
            public boolean drawArcLabels(Arc arc) {
                return processToImageMap.drawArcLabels(arc);
            }

            @Override
            public boolean drawSelfArcs(Arc arc) {
                return false;
            }

            @Override
            public boolean isBackArc(Arc arc, boolean defaultValue) {
                return processToImageMap.isBackArc(arc, defaultValue);
            }

            @Override
            public Widget newWidget(VisualProcessNode node, SarasvatiProcessScene scene) {
                Icon icon = processToImageMap.iconForNode(node);
                JLabel label = new JLabel(icon);
                label.setSize(icon.getIconWidth(), icon.getIconHeight());
                return new ComponentWidget((Scene)scene, (Component)label);
            }
        };
        SarasvatiProcessScene processScene = new SarasvatiProcessScene(process, lookAndFeelAdapter);
        processScene.setupForExportOnHeadless();
        StringBuilder buf = new StringBuilder(1024);
        ProcessHrefFunctionAdapter hrefMapper = new ProcessHrefFunctionAdapter(processToImageMap);
        ProcessHoverFunctionAdapter hoverMapper = new ProcessHoverFunctionAdapter(processToImageMap);
        this.image = processScene.export(buf, hrefMapper, hoverMapper);
        this.mapContents = buf.toString();
    }

    public String getMapContents() {
        return this.mapContents;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void writeImageToFile(String imageFormat, String imageFileName) throws IOException {
        ImageIO.write((RenderedImage)this.image, imageFormat, new File(imageFileName));
        this.image.flush();
    }
}

