/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.common;

import com.googlecode.sarasvati.adapter.Function;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.common.PathTrackingConnectionWidget;
import com.googlecode.sarasvati.visual.common.ShortestPathRouterAdapter;
import com.googlecode.sarasvati.visual.util.ConvertUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.export.WidgetPolygonalCoordinates;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.export.Scene2Image;

public abstract class GraphSceneImpl<N, E>
extends GraphScene<N, E> {
    protected LayerWidget mainLayer = new LayerWidget((Scene)this);
    protected LayerWidget intrLayer = new LayerWidget((Scene)this);
    protected LayerWidget connLayer = new LayerWidget((Scene)this);
    protected ShortestPathRouterAdapter router;
    protected Map<N, Anchor> anchorMap = new HashMap<N, Anchor>();

    public GraphSceneImpl() {
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.intrLayer);
        this.addChild((Widget)this.connLayer);
        this.router = new ShortestPathRouterAdapter(this, 10);
        this.addSceneListener(new Scene.SceneListener(){

            public void sceneValidating() {
            }

            public void sceneValidated() {
            }

            public void sceneRepaint() {
                GraphSceneImpl.this.router.sceneValidated();
            }
        });
    }

    public void setAdjacentLineSpacing(int spacing) {
        this.router.setAdjacentLineSpacing(spacing);
    }

    public LayerWidget getConnectionLayer() {
        return this.connLayer;
    }

    protected void attachEdgeSourceAnchor(E edge, N oldSourceNode, N sourceNode) {
        ConnectionWidget edgeWidget = (ConnectionWidget)this.findWidget(edge);
        edgeWidget.setSourceAnchor(this.anchorMap.get(sourceNode));
    }

    protected void attachEdgeTargetAnchor(E edge, N oldTargetNode, N targetNode) {
        ConnectionWidget edgeWidget = (ConnectionWidget)this.findWidget(edge);
        edgeWidget.setTargetAnchor(this.anchorMap.get(targetNode));
    }

    protected PathTrackingConnectionWidget attachEdgeWidget(E edge) {
        PathTrackingConnectionWidget conn = new PathTrackingConnectionWidget(this.router, this);
        conn.setRouter(this.router);
        conn.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.connLayer.addChild((Widget)conn);
        return conn;
    }

    protected Widget attachNodeWidget(N node) {
        Widget widget = this.widgetForNode(node);
        this.mainLayer.addChild(widget);
        this.anchorMap.put(node, AnchorFactory.createRectangularAnchor((Widget)widget));
        this.router.addNodeWidget(widget);
        return widget;
    }

    protected abstract Widget widgetForNode(N var1);

    protected void detachNodeWidget(N node, Widget widget) {
        super.detachNodeWidget(node, widget);
        this.router.removeNodeWidget(widget);
        this.anchorMap.remove(node);
    }

    public void setupForExportOnHeadless() {
        this.mainLayer.resolveBounds(new Point(0, 0), null);
        this.connLayer.resolveBounds(new Point(0, 0), null);
        this.intrLayer.resolveBounds(new Point(0, 0), null);
    }

    public BufferedImage export(StringBuilder buf, Function<String, Widget> hrefMapper, Function<String, Widget> titleMapper) {
        Rectangle bounds = this.getPreferredBounds();
        BufferedImage image = new BufferedImage(bounds.width + NodeDrawConfig.getHorizontalNodeSpacing(), bounds.height + 20, 6);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.validate(g);
        this.paint(g);
        Scene2Image s = new Scene2Image((Scene)this, null);
        s.setScale(1.0);
        ArrayList coords = s.getSceneImageMapCoordinates(0);
        for (WidgetPolygonalCoordinates coord : coords) {
            buf.append("<area shape=\"poly\" coords=\"");
            ConvertUtil.appendPolygon(coord.getPolygon(), buf);
            buf.append("\" ");
            String result = (String)hrefMapper.apply((Object)coord.getWidget());
            if (result != null && result.length() != 0) {
                buf.append(" href=\"");
                buf.append(result);
                buf.append("\" ");
            } else {
                buf.append(" nohref ");
            }
            result = (String)titleMapper.apply((Object)coord.getWidget());
            if (result != null && result.length() != 0) {
                buf.append("title=\"");
                buf.append((String)titleMapper.apply((Object)coord.getWidget()));
                buf.append("\"");
            }
            buf.append(">\n");
        }
        return image;
    }
}

