/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.common;

import com.googlecode.sarasvati.util.SvUtil;
import com.googlecode.sarasvati.visual.common.GraphSceneImpl;
import com.googlecode.sarasvati.visual.common.ShortestPathRouterAdapter;
import com.googlecode.sarasvati.visual.util.ConvertUtil;
import com.googlecode.sarasvati.visual.util.SvGraphicsUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Path;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class PathTrackingConnectionWidget
extends ConnectionWidget {
    protected ShortestPathRouterAdapter router;
    protected Point start = null;
    protected Point end = null;
    protected Path path;
    protected List<Point> route;

    public PathTrackingConnectionWidget(ShortestPathRouterAdapter router, GraphSceneImpl<?, ?> scene) {
        super(scene);
        this.router = router;
    }

    public Rectangle getSourceBounds() {
        Widget widget = this.getSourceAnchor().getRelatedWidget();
        return widget == null ? null : SvGraphicsUtil.getBounds(widget);
    }

    public Rectangle getTargetBounds() {
        Widget widget = this.getTargetAnchor().getRelatedWidget();
        return widget == null ? null : SvGraphicsUtil.getBounds(widget);
    }

    public boolean ensurePathCurrent() {
        Anchor sourceAnchor = this.getSourceAnchor();
        Anchor targetAnchor = this.getTargetAnchor();
        if (sourceAnchor != null && targetAnchor != null) {
            boolean pathChange;
            boolean isSelfArc;
            Point newStart = null;
            Point newEnd = null;
            boolean bl = isSelfArc = sourceAnchor.getRelatedWidget() != null && SvUtil.equals((Object)sourceAnchor.getRelatedWidget(), (Object)targetAnchor.getRelatedWidget());
            if (isSelfArc) {
                Point origin = sourceAnchor.getRelatedWidget().getLocation();
                Rectangle bounds = sourceAnchor.getRelatedWidget().getBounds();
                newStart = new Point(origin.x + (bounds.width >> 1), origin.y + bounds.height + 1);
                newEnd = new Point(origin.x - 1, origin.y + (bounds.height >> 1));
            } else {
                newStart = sourceAnchor.compute(this.getSourceAnchorEntry()).getAnchorSceneLocation();
                newEnd = targetAnchor.compute(this.getTargetAnchorEntry()).getAnchorSceneLocation();
                SvGraphicsUtil.movePointOutOfBounds(newStart, this.getSourceBounds());
                SvGraphicsUtil.movePointOutOfBounds(newEnd, this.getTargetBounds());
            }
            boolean bl2 = pathChange = this.path == null || !this.start.equals(newStart) || !this.end.equals(newEnd);
            if (pathChange) {
                if (this.path != null) {
                    this.router.removePath(this.path);
                }
                this.start = newStart;
                this.end = newEnd;
                this.path = new Path(ConvertUtil.awtToSwt(this.start), ConvertUtil.awtToSwt(this.end));
                this.path.data = this;
                this.router.addPath(this.path, isSelfArc);
            }
            return pathChange;
        }
        this.router.removePath(this.path);
        this.start = null;
        this.end = null;
        this.path = null;
        return true;
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }

    public void updateRoute() {
        PointList pointList = this.path.getPoints();
        this.route = new ArrayList<Point>(pointList.size());
        for (int i = 0; i < pointList.size(); ++i) {
            Point point = ConvertUtil.swtToAwt(pointList.getPoint(i));
            this.route.add(point);
        }
    }

    public List<Point> getRoute() {
        return this.route;
    }
}

