/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.common;

import com.googlecode.sarasvati.util.SvUtil;
import com.googlecode.sarasvati.visual.common.GraphSceneImpl;
import com.googlecode.sarasvati.visual.common.PathTrackingConnectionWidget;
import com.googlecode.sarasvati.visual.util.ConvertUtil;
import com.googlecode.sarasvati.visual.util.SvGraphicsUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class ShortestPathRouterAdapter
implements Router {
    protected GraphSceneImpl<?, ?> scene;
    protected ShortestPathRouter router;
    protected Map<Widget, WidgetBoundsTracker> widgetMap = new HashMap<Widget, WidgetBoundsTracker>();

    public ShortestPathRouterAdapter(GraphSceneImpl<?, ?> scene, int spacing) {
        this.scene = scene;
        this.router = new ShortestPathRouter();
        this.router.setSpacing(spacing);
    }

    public void setAdjacentLineSpacing(int spacing) {
        this.router.setSpacing(spacing);
    }

    public void addNodeWidget(Widget w) {
        this.widgetMap.put(w, new WidgetBoundsTracker(w));
    }

    public void removeNodeWidget(Widget w) {
        WidgetBoundsTracker boundsTracker = this.widgetMap.remove(w);
        if (boundsTracker != null) {
            boundsTracker.cleanup();
        }
    }

    public void sceneValidated() {
        boolean updates = false;
        for (WidgetBoundsTracker boundsTracker : this.widgetMap.values()) {
            updates |= boundsTracker.checkBounds();
        }
        if (updates) {
            this.updateRoutes();
            this.scene.revalidate();
        }
    }

    public void addPath(Path path, boolean isSelfArc) {
        for (Widget w : this.scene.connLayer.getChildren()) {
            List<Point> route;
            PathTrackingConnectionWidget conn;
            if (path.data == w || !(w instanceof PathTrackingConnectionWidget) || (conn = (PathTrackingConnectionWidget)w).getStart() == null || conn.getEnd() == null || ((route = conn.getRoute()) == null || route.size() != 2 || !ConvertUtil.awtToSwt(conn.getEnd()).equals((Object)path.getStartPoint()) || !ConvertUtil.awtToSwt(conn.getStart()).equals((Object)path.getEndPoint())) && (!ConvertUtil.awtToSwt(conn.getStart()).equals((Object)path.getStartPoint()) || !ConvertUtil.awtToSwt(conn.getEnd()).equals((Object)path.getEndPoint()))) continue;
            SvGraphicsUtil.addOffsetBendToPath(path, this.router.getSpacing());
            break;
        }
        if (isSelfArc) {
            int offset = 15;
            PointList bendPoints = new PointList();
            bendPoints.addPoint(path.getStartPoint().x, path.getStartPoint().y + offset);
            bendPoints.addPoint(path.getEndPoint().x - offset, path.getStartPoint().y + offset);
            bendPoints.addPoint(path.getEndPoint().x - offset, path.getEndPoint().y);
            path.setBendPoints(bendPoints);
        }
        this.router.addPath(path);
    }

    public void removePath(Path path) {
        this.router.removePath(path);
    }

    public void updateRoutes() {
        List paths = this.router.solve();
        for (Path p : paths) {
            PathTrackingConnectionWidget pathTrackingCW = (PathTrackingConnectionWidget)((Object)p.data);
            pathTrackingCW.updateRoute();
            pathTrackingCW.revalidate();
        }
    }

    public List<Point> routeConnection(ConnectionWidget conn) {
        PathTrackingConnectionWidget pathTrackingCW = (PathTrackingConnectionWidget)conn;
        if (pathTrackingCW.ensurePathCurrent()) {
            this.updateRoutes();
        }
        return pathTrackingCW.getRoute();
    }

    public class WidgetBoundsTracker {
        private Widget widget;
        private org.eclipse.draw2d.geometry.Rectangle bounds;

        public WidgetBoundsTracker(Widget widget) {
            this.widget = widget;
        }

        public org.eclipse.draw2d.geometry.Rectangle getNewBounds() {
            Rectangle newBounds = this.widget.getBounds();
            if (newBounds == null) {
                return null;
            }
            newBounds.setLocation(this.widget.getLocation());
            return ConvertUtil.awtToSwt(newBounds);
        }

        public boolean checkBounds() {
            org.eclipse.draw2d.geometry.Rectangle newBounds = this.getNewBounds();
            if (SvUtil.equals((Object)this.bounds, (Object)newBounds)) {
                return false;
            }
            if (this.bounds == null) {
                if (newBounds != null) {
                    ShortestPathRouterAdapter.this.router.addObstacle(newBounds);
                }
            } else if (newBounds == null) {
                ShortestPathRouterAdapter.this.router.removeObstacle(this.bounds);
            } else {
                ShortestPathRouterAdapter.this.router.updateObstacle(this.bounds, newBounds);
            }
            this.bounds = newBounds;
            return true;
        }

        public void cleanup() {
            if (this.bounds != null) {
                ShortestPathRouterAdapter.this.router.removeObstacle(this.bounds);
            }
        }
    }
}

