/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.graph;

import com.googlecode.sarasvati.visual.common.NodeDrawConfig;

public class GraphLayoutNode<N> {
    protected N node;
    protected int depth;
    protected int index;
    protected int originX;
    protected int originY;

    public GraphLayoutNode(int depth, N node) {
        this.node = node;
        this.depth = depth;
    }

    public N getNode() {
        return this.node;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.recalculateOrigin();
    }

    public void recalculateOrigin() {
        int xBasis = NodeDrawConfig.isVertical() ? this.getIndex() : this.getDepth();
        int yBasis = NodeDrawConfig.isVertical() ? this.getDepth() : this.getIndex();
        this.originX = (xBasis + 1) * NodeDrawConfig.getHorizontalNodeSpacing() + xBasis * (NodeDrawConfig.getMaxNodeRadius() << 1) + NodeDrawConfig.getMaxNodeRadius();
        this.originY = yBasis * NodeDrawConfig.getVerticalNodeSpacing() + yBasis * (NodeDrawConfig.getMaxNodeRadius() << 1) + NodeDrawConfig.getMaxNodeRadius();
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginX(int width) {
        return this.originX + (NodeDrawConfig.getMaxNodeRadius() - (width >> 1));
    }

    public int getOriginY(int height) {
        return this.originY + (NodeDrawConfig.getMaxNodeRadius() - (height >> 1));
    }

    public int getOffset() {
        return NodeDrawConfig.getMaxNodeRadius() >> 1;
    }
}

