/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.graph;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.graph.AbstractLayoutTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GraphLayoutTree
extends AbstractLayoutTree<Node> {
    private final Graph graph;

    public GraphLayoutTree(Graph graph) {
        this.graph = graph;
        this.init();
    }

    @Override
    protected Collection<Node> getNodes() {
        return this.graph.getNodes();
    }

    @Override
    protected Collection<Node> getStartNodes() {
        return this.graph.getStartNodes();
    }

    @Override
    protected Collection<Node> getOutputs(Node node) {
        List arcs = this.graph.getOutputArcs(node);
        ArrayList<Node> outputs = new ArrayList<Node>(arcs.size());
        for (Arc arc : arcs) {
            outputs.add(arc.getEndNode());
        }
        return outputs;
    }

    @Override
    protected Collection<Node> getInputs(Node node) {
        List arcs = this.graph.getInputArcs(node);
        ArrayList<Node> inputs = new ArrayList<Node>(arcs.size());
        for (Arc arc : arcs) {
            inputs.add(arc.getStartNode());
        }
        return inputs;
    }

    @Override
    protected boolean hasNoInputs(Node node) {
        return this.graph.getInputArcs(node).isEmpty();
    }
}

