/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.icon;

import com.googlecode.sarasvati.visual.icon.IconFactory;
import com.googlecode.sarasvati.visual.icon.NodeIconType;
import com.googlecode.sarasvati.visual.icon.OvalNodeIcon;
import com.googlecode.sarasvati.visual.icon.RectangularNodeIcon;
import com.googlecode.sarasvati.visual.icon.SmallCircleNodeIcon;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class NodeIcons {
    private static final Map<NodeIconType, IconFactory> iconFactories = new HashMap<NodeIconType, IconFactory>();

    public static Icon newInstance(NodeIconType nodeIconType, String label, Color color, boolean isJoin, boolean isSelected) {
        return iconFactories.get((Object)nodeIconType).newIcon(label, color, isJoin, isSelected);
    }

    static {
        iconFactories.put(NodeIconType.Oval, new IconFactory(){

            @Override
            public Icon newIcon(String label, Color backgroundColor, boolean isJoin, boolean isSelected) {
                return new OvalNodeIcon(label, backgroundColor, isJoin, isSelected);
            }
        });
        iconFactories.put(NodeIconType.Rectangular, new IconFactory(){

            @Override
            public Icon newIcon(String label, Color backgroundColor, boolean isJoin, boolean isSelected) {
                return new RectangularNodeIcon(label, backgroundColor, isJoin, isSelected);
            }
        });
        iconFactories.put(NodeIconType.SmallCircle, new IconFactory(){

            @Override
            public Icon newIcon(String label, Color backgroundColor, boolean isJoin, boolean isSelected) {
                return new SmallCircleNodeIcon(backgroundColor, isJoin, isSelected);
            }
        });
    }
}

