/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.icon;

import com.googlecode.sarasvati.JoinType;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.icon.AbstractNodeIcon;
import com.googlecode.sarasvati.visual.util.FontUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class OvalNodeIcon
extends AbstractNodeIcon {
    protected String label;
    protected final Color color;
    protected final boolean isJoin;
    protected final boolean isSelected;

    public OvalNodeIcon(Node node, NodeToken token) {
        this.label = (String)node.getAdaptor(String.class);
        if (this.label == null) {
            this.label = node.getName();
        }
        this.isJoin = node.getJoinType() != JoinType.OR;
        this.color = NodeDrawConfig.getColor(token);
        this.isSelected = false;
        this.redrawImage();
    }

    public OvalNodeIcon(String label, Color color, boolean isJoin, boolean isSelected) {
        this.label = label;
        this.color = color;
        this.isJoin = isJoin;
        this.isSelected = isSelected;
        this.redrawImage();
    }

    @Override
    public void redrawImage(Graphics2D g) {
        int padding;
        float[] fArray;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.fillOval(0, 0, 99, HEIGHT - 1);
        g.setColor(this.isSelected ? NodeDrawConfig.NODE_BORDER_SELECTED : NodeDrawConfig.NODE_BORDER);
        if (this.isJoin) {
            float[] fArray2 = new float[2];
            fArray2[0] = 10.0f;
            fArray = fArray2;
            fArray2[1] = 5.0f;
        } else {
            fArray = null;
        }
        float[] dashes = fArray;
        int offset = 1;
        BasicStroke stroke = new BasicStroke(3.0f, 2, 0, 10.0f, dashes, 0.0f);
        g.setStroke(stroke);
        int width = 100 - ((offset << 1) + 1);
        int height = HEIGHT - ((offset << 1) + 1);
        g.drawOval(offset, offset, width, height);
        g.setColor(Color.white);
        int startX = padding = 2 + (offset += 3);
        int maxWidth = this.getIconWidth() - (padding << 1);
        g.setFont(g.getFont().deriveFont(1));
        FontUtil.setSizedFont(g, this.label, 11.0f, maxWidth);
        int strWidth = (int)Math.ceil(g.getFontMetrics().getStringBounds(this.label, g).getWidth());
        int strHeight = g.getFontMetrics().getAscent();
        int left = startX + (maxWidth - strWidth >> 1);
        int top = this.getIconHeight() + strHeight >> 1;
        g.drawString(this.label, left, top);
    }
}

