/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.icon;

import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.icon.AbstractNodeIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;

public class SmallCircleNodeIcon
extends AbstractNodeIcon {
    protected final Color color;
    protected final boolean isJoin;
    protected final boolean isSelected;

    public SmallCircleNodeIcon() {
        this.color = Color.BLACK.brighter();
        this.isJoin = false;
        this.isSelected = false;
        this.redrawImage();
    }

    public SmallCircleNodeIcon(Color color, boolean isJoin, boolean isSelected) {
        this.color = color;
        this.isJoin = isJoin;
        this.isSelected = isSelected;
        this.redrawImage();
    }

    @Override
    public void redrawImage(Graphics2D g) {
        float[] fArray;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double diameter = HEIGHT;
        double outerCircle = diameter * 0.7;
        double innerCircle = diameter * 0.5;
        g.setColor(this.isSelected ? NodeDrawConfig.NODE_BORDER_SELECTED : NodeDrawConfig.NODE_BORDER);
        if (this.isJoin) {
            float[] fArray2 = new float[2];
            fArray2[0] = 10.0f;
            fArray = fArray2;
            fArray2[1] = 5.0f;
        } else {
            fArray = null;
        }
        float[] dashes = fArray;
        BasicStroke stroke = new BasicStroke(3.0f, 2, 0, 10.0f, dashes, 0.0f);
        g.setStroke(stroke);
        boolean offset = true;
        g.translate(((double)HEIGHT - outerCircle) / 2.0, (double)offset);
        g.draw(new Ellipse2D.Double(0.0, 0.0, outerCircle, outerCircle));
        g.setColor(this.color);
        g.translate((outerCircle - innerCircle) / 2.0, (outerCircle - innerCircle) / 2.0);
        g.fill(new Ellipse2D.Double(0.0, 0.0, innerCircle, innerCircle));
    }

    @Override
    public int getIconWidth() {
        return this.getIconHeight();
    }
}

