/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.process;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.ArcToken;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.visual.ProcessLookAndFeel;
import com.googlecode.sarasvati.visual.common.GraphSceneImpl;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.process.ProcessTree;
import com.googlecode.sarasvati.visual.process.ProcessTreeArc;
import com.googlecode.sarasvati.visual.process.ProcessTreeNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SarasvatiProcessScene
extends GraphSceneImpl<ProcessTreeNode, ProcessTreeArc> {
    protected static final Font ARC_LABEL_FONT = Font.decode("serif bold 11");
    protected ProcessLookAndFeel lookAndFeel;

    public SarasvatiProcessScene(GraphProcess process, ProcessLookAndFeel lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
        if (process != null) {
            ProcessTree processTree = new ProcessTree(process, lookAndFeel);
            Iterable<ProcessTreeNode> nodes = processTree.getProcessTreeNodes();
            for (ProcessTreeNode node : nodes) {
                Widget widget = this.addNode(node);
                Rectangle bounds = widget.getPreferredBounds();
                Point origin = new Point(node.getOriginX(bounds.width), node.getOriginY(bounds.height));
                widget.setPreferredLocation(origin);
                widget.resolveBounds(origin, null);
            }
            for (ProcessTreeNode node : nodes) {
                for (ProcessTreeArc ptArc : node.getChildren()) {
                    Arc arc = ptArc.getArc();
                    if (!lookAndFeel.drawSelfArcs(arc) && ptArc.getParent().equals(ptArc.getChild())) continue;
                    ConnectionWidget w = (ConnectionWidget)this.addEdge(ptArc);
                    this.setEdgeSource(ptArc, ptArc.getParent());
                    this.setEdgeTarget(ptArc, ptArc.getChild());
                    ArcToken token = ptArc.getToken();
                    if (token != null) {
                        w.setStroke((Stroke)new BasicStroke(3.0f));
                        if (token.getExecutionType().isBacktracked()) {
                            w.setLineColor(NodeDrawConfig.NODE_BG_BACKTRACKED);
                        } else if (token.isComplete()) {
                            w.setLineColor(NodeDrawConfig.NODE_BG_COMPLETED);
                        } else {
                            w.setLineColor(NodeDrawConfig.NODE_BG_ACTIVE);
                        }
                    }
                    w.resolveBounds(null, null);
                    if (arc.getName() == null || !lookAndFeel.drawArcLabels(arc)) continue;
                    LabelWidget arcLabel = new LabelWidget((Scene)this, arc.getName());
                    arcLabel.setFont(ARC_LABEL_FONT);
                    arcLabel.setForeground(Color.BLUE);
                    arcLabel.setOpaque(true);
                    w.addChild((Widget)arcLabel);
                    w.setConstraint((Widget)arcLabel, LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER, 30);
                }
            }
        }
        this.revalidate();
    }

    @Override
    protected Widget widgetForNode(ProcessTreeNode node) {
        return this.lookAndFeel.newWidget(node, this);
    }
}

