/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.util;

import java.awt.Point;
import java.awt.Rectangle;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Path;
import org.netbeans.api.visual.widget.Widget;

public class SvGraphicsUtil {
    public static void addOffsetBendToPath(Path path, int spacing) {
        PointList bendPoints = new PointList();
        int deltaX = path.getEndPoint().x - path.getStartPoint().x;
        int y = (path.getEndPoint().y + path.getStartPoint().y >> 1) + Math.min(Math.abs(deltaX), spacing);
        int deltaY = path.getEndPoint().y - path.getStartPoint().y;
        int offset = Math.min(Math.abs(deltaY), spacing);
        if (deltaX > 0 && deltaY > 0 || deltaX < 0 && deltaY < 0) {
            offset = -offset;
        }
        int x = (path.getEndPoint().x + path.getStartPoint().x >> 1) + offset;
        bendPoints.addPoint(x, y);
        path.setBendPoints(bendPoints);
    }

    public static Rectangle getBounds(Widget widget) {
        Rectangle bounds = widget.getBounds();
        bounds.setLocation(widget.getLocation());
        return bounds;
    }

    public static void movePointOutOfBounds(Point point, Rectangle bounds) {
        if (bounds != null) {
            if (point.x == bounds.x) {
                --point.x;
            } else if (point.x == bounds.x + bounds.width) {
                ++point.x;
            }
            if (point.y == bounds.y) {
                --point.y;
            } else if (point.y == bounds.y + bounds.height) {
                ++point.y;
            }
        }
    }
}

