/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.visual.ProcessLookAndFeel;
import com.googlecode.sarasvati.visual.icon.OvalNodeIcon;
import com.googlecode.sarasvati.visual.icon.RectangularNodeIcon;
import com.googlecode.sarasvati.visual.icon.SmallCircleNodeIcon;
import com.googlecode.sarasvati.visual.process.SarasvatiProcessScene;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class DefaultProcessLookAndFeel
implements ProcessLookAndFeel {
    public static final DefaultProcessLookAndFeel INSTANCE = new DefaultProcessLookAndFeel(false, true);
    protected boolean drawSelfArcs;
    protected boolean drawArcLabels;

    public DefaultProcessLookAndFeel(boolean drawSelfArcs, boolean drawArcLabels) {
        this.drawSelfArcs = drawSelfArcs;
        this.drawArcLabels = drawArcLabels;
    }

    @Override
    public boolean drawArcLabels(Arc arc) {
        return this.drawArcLabels;
    }

    @Override
    public boolean drawSelfArcs(Arc arc) {
        return this.drawSelfArcs;
    }

    public Icon newIconForNode(VisualProcessNode node) {
        String nodeType = node.getNode().getType();
        if (nodeType.equalsIgnoreCase(this.getTaskType())) {
            return new RectangularNodeIcon(node.getNode(), node.getToken());
        }
        if (nodeType.equalsIgnoreCase("end")) {
            return new SmallCircleNodeIcon();
        }
        return new OvalNodeIcon(node.getNode(), node.getToken());
    }

    @Override
    public Widget newWidget(VisualProcessNode node, SarasvatiProcessScene scene) {
        Icon icon = this.newIconForNode(node);
        JLabel label = new JLabel(icon);
        label.setSize(icon.getIconWidth(), icon.getIconHeight());
        return new ComponentWidget((Scene)scene, (Component)label);
    }

    protected String getTaskType() {
        return "task";
    }

    @Override
    public boolean isBackArc(Arc arc, boolean defaultValue) {
        return defaultValue;
    }
}

