/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.common;

import com.googlecode.sarasvati.GuardAction;
import com.googlecode.sarasvati.NodeToken;
import java.awt.Color;

public class NodeDrawConfig {
    private static int maxNodeRadius = 20;
    private static int verticalNodeSpacing = 50;
    private static int horizontalNodeSpacing = 100;
    private static boolean vertical = true;
    public static final Color NODE_BORDER = Color.black;
    public static final Color NODE_BORDER_SELECTED = new Color(204, 204, 204);
    public static final Color NODE_BACKGROUND = new Color(153, 153, 153);
    public static final Color NODE_BG_ACTIVE = new Color(153, 153, 0);
    public static final Color NODE_BG_DISCARDED = new Color(204, 102, 0);
    public static final Color NODE_BG_SKIPPED = new Color(255, 204, 51);
    public static final Color NODE_BG_COMPLETED = new Color(0, 153, 204);
    public static final Color NODE_BG_BACKTRACKED = new Color(153, 0, 51);

    public static Color getColor(NodeToken token) {
        if (token == null) {
            return NODE_BACKGROUND;
        }
        if (token.getExecutionType().isBacktracked()) {
            return NODE_BG_BACKTRACKED;
        }
        if (token.getGuardAction() == GuardAction.AcceptToken) {
            return token.isComplete() ? NODE_BG_COMPLETED : NODE_BG_ACTIVE;
        }
        if (token.getGuardAction() == GuardAction.DiscardToken) {
            return NODE_BG_DISCARDED;
        }
        return NODE_BG_SKIPPED;
    }

    public static int getMaxNodeRadius() {
        return maxNodeRadius;
    }

    public static void setMaxNodeRadius(int newMaxNodeRadius) {
        maxNodeRadius = newMaxNodeRadius;
    }

    public static int getVerticalNodeSpacing() {
        return verticalNodeSpacing;
    }

    public static void setVerticalNodeSpacing(int newVerticalNodeSpacing) {
        verticalNodeSpacing = newVerticalNodeSpacing;
    }

    public static int getHorizontalNodeSpacing() {
        return horizontalNodeSpacing;
    }

    public static void sethorizontalNodeSpacing(int newHorizontalNodeSpacing) {
        horizontalNodeSpacing = newHorizontalNodeSpacing;
    }

    public static void setVertical(boolean isVertical) {
        vertical = isVertical;
    }

    public static boolean isVertical() {
        return vertical;
    }
}

