/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.graph;

import com.googlecode.sarasvati.visual.graph.GraphLayoutNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractLayoutTree<N> {
    protected Map<N, GraphLayoutNode<N>> nodeMap = new HashMap<N, GraphLayoutNode<N>>();

    protected abstract Collection<N> getNodes();

    protected abstract Collection<N> getStartNodes();

    protected abstract boolean hasNoInputs(N var1);

    protected abstract Collection<N> getOutputs(N var1);

    protected abstract Collection<N> getInputs(N var1);

    public void init() {
        Collection<N> nodes;
        LinkedList<GraphLayoutNode<Object>> nextLayer = new LinkedList<GraphLayoutNode<N>>();
        Collection<N> startNodes = this.getStartNodes();
        for (N node : this.getNodes()) {
            if (!this.hasNoInputs(node) || startNodes.contains(node)) continue;
            startNodes.add(node);
        }
        if (startNodes.isEmpty() && !(nodes = this.getNodes()).isEmpty()) {
            startNodes = new ArrayList<N>(1);
            startNodes.add(nodes.iterator().next());
        }
        for (N node : startNodes) {
            GraphLayoutNode<N> treeNode = new GraphLayoutNode<N>(0, node);
            this.nodeMap.put(node, treeNode);
            nextLayer.add(treeNode);
        }
        this.sortLayer(nextLayer);
        LinkedList<GraphLayoutNode<N>> layer = null;
        int depth = 1;
        while (!nextLayer.isEmpty()) {
            layer = nextLayer;
            nextLayer = new LinkedList();
            HashSet layerNodes = new HashSet();
            for (GraphLayoutNode graphLayoutNode : layer) {
                for (Object target : this.getOutputs(graphLayoutNode.getNode())) {
                    GraphLayoutNode<N> targetTreeNode = this.nodeMap.get(target);
                    if (targetTreeNode != null) continue;
                    boolean allAncestorsTraversed = true;
                    for (Object input : this.getInputs(target)) {
                        if (this.nodeMap.containsKey(input) && !layerNodes.contains(input) || target.equals(input) || this.isParentAlsoChild(input, target)) continue;
                        allAncestorsTraversed = false;
                        break;
                    }
                    if (!allAncestorsTraversed) continue;
                    targetTreeNode = new GraphLayoutNode(depth, target);
                    this.nodeMap.put(target, targetTreeNode);
                    nextLayer.add(targetTreeNode);
                    layerNodes.add(target);
                }
            }
            this.sortLayer(nextLayer);
            ++depth;
        }
    }

    private void sortLayer(List<GraphLayoutNode<N>> layer) {
        int index = 0;
        for (GraphLayoutNode<N> layoutNode : layer) {
            layoutNode.setIndex(index++);
        }
    }

    private boolean isParentAlsoChild(N parent, N child) {
        HashSet<Object> processed = new HashSet<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        processed.add(parent);
        queue.addAll(this.getInputs(parent));
        while (!queue.isEmpty()) {
            Object node = queue.remove();
            if (node.equals(child)) {
                return true;
            }
            processed.add(node);
            for (Object input : this.getInputs(node)) {
                if (processed.contains(input)) continue;
                queue.add(input);
            }
        }
        return false;
    }

    public GraphLayoutNode<N> getTreeNode(N node) {
        return this.nodeMap.get(node);
    }

    public boolean isBackArc(N start, N end) {
        GraphLayoutNode<N> startNode = this.getTreeNode(start);
        GraphLayoutNode<N> endNode = this.getTreeNode(end);
        return endNode.getDepth() < startNode.getDepth();
    }
}

