/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.icon;

import com.googlecode.sarasvati.JoinType;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.icon.AbstractNodeIcon;
import com.googlecode.sarasvati.visual.util.FontUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class RectangularNodeIcon
extends AbstractNodeIcon {
    protected boolean isJoin;
    protected String label;
    protected Color color;
    protected boolean isSelected;

    public RectangularNodeIcon(Node node, NodeToken token) {
        this.label = (String)node.getAdaptor(String.class);
        this.isJoin = node.getJoinType() != JoinType.OR;
        this.color = NodeDrawConfig.getColor(token);
        this.redrawImage();
    }

    public RectangularNodeIcon(String label, Color color, boolean isJoin, boolean isSelected) {
        this.label = label;
        this.color = color;
        this.isJoin = isJoin;
        this.isSelected = isSelected;
        this.redrawImage();
    }

    @Override
    public void redrawImage(Graphics2D g) {
        int padding;
        float[] fArray;
        g.setFont(g.getFont().deriveFont(1));
        g.setColor(this.color);
        g.fillOval(0, 0, 99, HEIGHT - 1);
        g.fillRoundRect(0, 0, 99, HEIGHT - 1, 10, 10);
        if (this.isJoin) {
            float[] fArray2 = new float[2];
            fArray2[0] = 10.0f;
            fArray = fArray2;
            fArray2[1] = 5.0f;
        } else {
            fArray = null;
        }
        float[] dashes = fArray;
        int offset = 1;
        BasicStroke stroke = new BasicStroke(3.0f, 2, 0, 10.0f, dashes, 0.0f);
        g.setStroke(stroke);
        g.setColor(this.isSelected ? NodeDrawConfig.NODE_BORDER_SELECTED : NodeDrawConfig.NODE_BORDER);
        int width = 100 - ((offset << 1) + 1);
        int height = HEIGHT - ((offset << 1) + 1);
        g.drawRoundRect(offset, offset, width, height, 10, 10);
        g.setColor(Color.white);
        String[] lines = FontUtil.split(this.label);
        int startX = padding = 2 + offset;
        int maxWidth = this.getIconWidth() - (padding << 1);
        if (lines.length == 1) {
            FontUtil.setSizedFont(g, this.label, 11.0f, maxWidth);
            int strWidth = (int)Math.ceil(g.getFontMetrics().getStringBounds(lines[0], g).getWidth());
            int left = startX + (maxWidth - strWidth >> 1);
            g.drawString(this.label, left, this.getIconHeight() >> 1);
        } else if (lines.length == 2) {
            FontUtil.setSizedFont(g, lines[0], 11.0f, maxWidth);
            int strWidth = (int)Math.ceil(g.getFontMetrics().getStringBounds(lines[0], g).getWidth());
            int left = startX + (maxWidth - strWidth >> 1);
            g.drawString(lines[0], left, this.getIconHeight() - offset >> 1);
            FontUtil.setSizedFont(g, lines[1], 11.0f, maxWidth);
            int strHeight = (int)Math.ceil(g.getFontMetrics().getStringBounds(lines[1], g).getHeight());
            strWidth = (int)Math.ceil(g.getFontMetrics().getStringBounds(lines[1], g).getWidth());
            left = startX + (maxWidth - strWidth >> 1);
            g.drawString(lines[1], left, (this.getIconHeight() - offset >> 1) + (strHeight + 1));
        }
    }
}

