/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sarasvati.visual.process;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.process.ProcessTree;
import com.googlecode.sarasvati.visual.process.ProcessTreeArc;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ProcessTreeNode
implements VisualProcessNode {
    protected ProcessTreeNode parent;
    protected NodeToken token;
    protected Node node;
    protected int depth = -1;
    protected int index;
    protected int originX;
    protected int originY;
    private List<ProcessTreeArc> children = new LinkedList<ProcessTreeArc>();
    private List<ProcessTreeArc> parents = new LinkedList<ProcessTreeArc>();

    public ProcessTreeNode(ProcessTreeNode parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    public void addParent(ProcessTreeArc parentArc) {
        this.parents.add(parentArc);
    }

    public ProcessTreeNode(NodeToken token) {
        this.token = token;
    }

    public ProcessTreeNode getParent() {
        return this.parent;
    }

    public NodeToken getParentToken() {
        for (ProcessTreeNode current = this.parent; current != null; current = current.getParent()) {
            if (current.getToken() == null) {
                continue;
            }
            return current.getToken();
        }
        return this.token;
    }

    @Override
    public Node getNode() {
        return this.token == null ? this.node : this.token.getNode();
    }

    @Override
    public NodeToken getToken() {
        return this.token;
    }

    public List<ProcessTreeArc> getChildren() {
        return this.children;
    }

    public List<ProcessTreeArc> getParents() {
        return this.parents;
    }

    public List<ProcessTreeNode> getNodeParents() {
        ArrayList<ProcessTreeNode> parentNodes = new ArrayList<ProcessTreeNode>(this.parents.size());
        for (ProcessTreeArc parentArc : this.parents) {
            parentNodes.add(parentArc.getParent());
        }
        return parentNodes;
    }

    public void addChild(ProcessTreeArc child) {
        this.children.add(child);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void addToLayer(List<ProcessTreeNode> layer) {
        this.index = layer.size();
        layer.add(this);
        this.recalculateOrigin();
    }

    public boolean isStartTokenNode() {
        return this.token != null && this.token.getParentTokens().isEmpty() && this.token.getNode().isStart();
    }

    public boolean isTokenOnArc(Arc arc) {
        for (ProcessTreeArc ptArc : this.children) {
            if (!ptArc.getArc().equals(arc) || ptArc.getToken() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isCompletedNodeToken() {
        return this.token != null && this.token.isComplete();
    }

    public boolean hasNonCompleteNodeTokenParent() {
        for (ProcessTreeArc parentArc : this.parents) {
            ProcessTreeNode currentParent = parentArc.getParent();
            if (currentParent == null || currentParent.getToken() == null || currentParent.getToken().isComplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLowerParent(ProcessTreeNode selectedParent, ProcessTree tree) {
        for (ProcessTreeArc parentArc : this.parents) {
            ProcessTreeNode currentParent = parentArc.getParent();
            if (currentParent == selectedParent || currentParent == this || currentParent.getDepth() <= selectedParent.getDepth() && currentParent.getDepth() != -1 || this.isAncestor(currentParent, tree)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestor(ProcessTreeNode ptNode, ProcessTree tree) {
        HashSet<ProcessTreeNode> visited = new HashSet<ProcessTreeNode>();
        LinkedList<ProcessTreeNode> queue = new LinkedList<ProcessTreeNode>();
        queue.add(ptNode);
        while (!queue.isEmpty()) {
            for (ProcessTreeArc currentArc : ((ProcessTreeNode)queue.remove()).parents) {
                ProcessTreeNode selectedParent = currentArc.getParent();
                if (visited.contains(selectedParent)) continue;
                visited.add(selectedParent);
                if (tree.isBackArc(currentArc.getArc())) continue;
                if (selectedParent == this) {
                    return true;
                }
                queue.add(selectedParent);
            }
        }
        return false;
    }

    public void recalculateOrigin() {
        int xBasis = NodeDrawConfig.isVertical() ? this.getIndex() : this.getDepth();
        int yBasis = NodeDrawConfig.isVertical() ? this.getDepth() : this.getIndex();
        this.originX = (xBasis + 1) * NodeDrawConfig.getHorizontalNodeSpacing() + xBasis * (NodeDrawConfig.getMaxNodeRadius() << 1) + NodeDrawConfig.getMaxNodeRadius();
        this.originY = yBasis * NodeDrawConfig.getVerticalNodeSpacing() + yBasis * (NodeDrawConfig.getMaxNodeRadius() << 1) + NodeDrawConfig.getMaxNodeRadius();
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginX(int width) {
        return this.originX + (NodeDrawConfig.getMaxNodeRadius() - (width >> 1));
    }

    public int getOriginY(int height) {
        return this.originY + (NodeDrawConfig.getMaxNodeRadius() - (height >> 1));
    }

    public int getOffset() {
        return NodeDrawConfig.getMaxNodeRadius() >> 1;
    }
}

