/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoContextListener
implements ServletContextListener {
    private static Logger log = LoggerFactory.getLogger(GeoContextListener.class);
    private static String SOLR_CONFIG = "solrconfig.xml";
    private static String SOLR_SCHEMA = "schema.xml";
    private CoreContainer solrContainer;
    private EmbeddedSolrServer solrServer;

    public void contextInitialized(ServletContextEvent sce) {
        log.info("\n=============\nStarting Solr:\n");
        String solrHome = System.getProperty("geonames.solr.home");
        if (solrHome == null) {
            log.error("No 'geonames.solr.home' provided!");
            return;
        }
        File solrDir = new File(solrHome);
        if (solrDir == null || !solrDir.exists() || !solrDir.isDirectory()) {
            log.error("SOLR_HOME does not exist, or is not a directory: '{}'", (Object)solrHome);
            return;
        }
        try {
            this.solrServer = this.startSolr(solrHome);
            log.info("\n... Solr is online\n=============\n");
            sce.getServletContext().setAttribute("solr", (Object)this.solrServer);
        }
        catch (Exception ex) {
            log.error("\n... Solr failed to load!");
            log.error("Stack trace: ", (Throwable)ex);
            log.error("\n=============");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.info("\n=============\nShutting down Solr\n");
        if (this.solrContainer != null) {
            this.solrContainer.shutdown();
        }
    }

    private EmbeddedSolrServer startSolr(String home) throws Exception {
        SolrConfig solrConfig = new SolrConfig(home, SOLR_CONFIG, null);
        IndexSchema schema = new IndexSchema(solrConfig, SOLR_SCHEMA, null);
        this.solrContainer = new CoreContainer(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
        CoreDescriptor descriptor = new CoreDescriptor(this.solrContainer, "", solrConfig.getResourceLoader().getInstanceDir());
        descriptor.setConfigName(solrConfig.getResourceName());
        descriptor.setSchemaName(schema.getResourceName());
        SolrCore solrCore = new SolrCore(null, solrConfig.getDataDir(), solrConfig, schema, descriptor);
        this.solrContainer.register("", solrCore, false);
        return new EmbeddedSolrServer(this.solrContainer, "");
    }
}

