/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.OpenSearchResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDebugResponse
implements OpenSearchResponse {
    private static Logger log = LoggerFactory.getLogger(HtmlDebugResponse.class);
    private HttpServletRequest request;

    public void init(HttpServletRequest request) {
        this.request = request;
    }

    public String renderResponse(QueryResponse results) {
        String table = this.resultsTables(results);
        String facets = this.facetsMenu(results);
        String debug = "<pre>" + results.toString() + "</pre>";
        return "<html><head><title>Debugging</title><link rel='stylesheet' type='text/css' href='styles.css' /></head><body><table class='debug'><tr><th>FACETS</th><th>RESULTS</th></tr><tr><td>" + facets + "</td><td>" + table + "</td></tr>" + "</table>" + "</body>" + "</html>";
    }

    private String facetsMenu(QueryResponse results) {
        String output = "";
        for (FacetField field : results.getFacetFields()) {
            String fieldName = field.getName();
            output = output + "<ul>";
            output = output + "<li class='heading'><b>" + fieldName + "</b></li>";
            for (FacetField.Count entry : field.getValues()) {
                long count = entry.getCount();
                if (count <= 0L) continue;
                String value = entry.getName();
                if (count == results.getResults().getNumFound()) {
                    output = output + "<li>" + value + " (" + count + ")</li>";
                    continue;
                }
                String link = this.facetLink(fieldName + ":" + value);
                output = output + "<li><a href='" + link + "'>" + value + "</a> (" + count + ")</li>";
            }
            output = output + "</ul>";
        }
        return output;
    }

    private String facetLink(String newFq) {
        String fq;
        String start;
        String link = "/geonames/search?func=debug&format=html";
        String q = this.request.getParameter("q");
        if (q == null) {
            q = "";
        }
        link = link + "&q=" + q;
        String rows = this.request.getParameter("rows");
        if (rows != null) {
            link = link + "&rows=" + rows;
        }
        if ((start = this.request.getParameter("start")) != null) {
            link = link + "&start=" + start;
        }
        link = (fq = this.request.getParameter("fq")) == null ? link + "&fq=" + newFq : link + "&fq=(" + newFq + ") AND (" + fq + ")";
        return link;
    }

    private String resultsTables(QueryResponse results) {
        String output = "<table class='results'>";
        output = output + "<tr><th>Location</th><th>Geonames URI</th><th>Country Code</th><th>Timezone</th><th>Feature Class</th><th>Feature Code</th><th>Score</th></tr>";
        for (SolrDocument doc : results.getResults()) {
            output = output + this.renderRow(doc);
        }
        output = output + "</table>";
        return output;
    }

    private String renderRow(SolrDocument doc) {
        String name = (String)doc.getFieldValue("basic_name");
        String id = (String)doc.getFieldValue("id");
        String country = (String)doc.getFieldValue("country_code");
        String timezone = (String)doc.getFieldValue("timezone");
        String fClass = (String)doc.getFieldValue("feature_class");
        String fCode = (String)doc.getFieldValue("feature_code");
        String score = String.valueOf((Float)doc.getFieldValue("score"));
        return "<tr><td>" + name + "</td>" + "<td><a href='http://sws.geonames.org/" + id + "/'>Geo</a> || <a href='/geonames/search?func=detail&amp;id=" + id + "'>Solr</a></td>" + "<td>" + country + "</td>" + "<td>" + timezone + "</td>" + "<td>" + fClass + "</td>" + "<td>" + fCode + "</td>" + "<td>" + score + "</td>" + "</tr>";
    }

    public String renderEmptyResponse() {
        return "Boo, 0 results";
    }

    public String renderError(String message) {
        return "Error: " + message;
    }

    public String contentType() {
        return "text/html";
    }
}

